<?php
session_start();

// Connect Database 
include 'Database.php';

// Initialize message variables
$generate_key_message = "";
$manage_key_message = "";
$ban_devices_message = "";
$upload_message = "";
$delete_message = "";
// Failed Message
$generate_failed_message = "";
$manage_key_failed_message = "";
$ban_devices_failed_message = "";
$upload_message_failed_message = "";
$delete_message_failed_message = "";

// Handle key and device operations
if ($_SERVER["REQUEST_METHOD"] == "POST") {
   if (isset($_POST['generate_key_vip'])) {
    // Lấy dữ liệu từ form
    $key_name = trim($_POST['key_name']);
    $expiration_date = trim($_POST['expiration_date']);
    $usage_limit = intval($_POST['usage_limit']);
    $game_type = trim($_POST['game_type']); // Lấy loại game

    // Validate key_name: Must not contain invalid characters
    if (!preg_match('/^[a-zA-Z0-9_]+$/', $key_name)) {
        $generate_failed_message = "Invalid key name, Only alphanumeric characters and underscores are allowed";
    }
    // Validate usage_limit: Must be greater than 0
    elseif ($usage_limit <= 0) {
        $generate_failed_message = "Usage limit must be greater than 0.";
    }
    // Validate expiration_date format
    elseif (!DateTime::createFromFormat('Y-m-d', $expiration_date)) {
        $generate_failed_message = "Invalid expiration date format. Use YYYY-MM-DD.";
    } else {
        // Định dạng ngày
        $expiration_date = date('Y-m-d', strtotime($expiration_date));
        // Tạo key với tiền tố
        $key = $game_type . "-" . $key_name;

        // Chuẩn bị và thực thi câu lệnh SQL
        $sql = "INSERT INTO api_keys (key_value, expiration_date, usage_limit) VALUES (?, ?, ?)";
        $stmt = $conn->prepare($sql);

        if ($stmt) {
            $stmt->bind_param("ssi", $key, $expiration_date, $usage_limit);

            if ($stmt->execute()) {
                $generate_key_message = "Key Created Successfully, Your Key: " . htmlspecialchars($key);
            } else {
                $generate_failed_message = "An error occurred while executing the statement: " . $stmt->error;
            }

            $stmt->close();
        } else {
            $generate_failed_message = "An error occurred while preparing the statement: " . $conn->error;
        }
    }
        
    } elseif (isset($_POST['delete_key']) && !empty($_POST['key_id'])) {
        $key_id = $_POST['key_id'];

        // Begin transaction
        $conn->begin_transaction();
        try {
            // Delete all device records associated with the specified api_key_id
            $sql = "DELETE FROM device_ids WHERE api_key_id = ?";
            $stmt = $conn->prepare($sql);
            if ($stmt) {
                $stmt->bind_param("i", $key_id);
                $stmt->execute();
                $stmt->close();
            } else {
                $manage_key_failed_message = "An error occurred while preparing the statement: " . $conn->error . "";
            }

            // Delete the key itself
            $sql = "DELETE FROM api_keys WHERE id = ?";
            $stmt = $conn->prepare($sql);
            if ($stmt) {
                $stmt->bind_param("i", $key_id);
                if ($stmt->execute()) {
                    $conn->commit();
                    $manage_key_message = "Deleted Key Successful !";
                } else {
                    $manage_key_failed_message = "An error occurred while deleting the key: " . $stmt->error . "";
                }
                $stmt->close();
            } else {
                $manage_key_failed_message = "An error occurred while preparing the statement: " . $conn->error . "";
            }
        } catch (Exception $e) {
            $conn->rollback();
            $manage_key_message = $e->getMessage();
        }

        
    } elseif (isset($_POST['update_expiration']) && !empty($_POST['key_id'])) {
        $key_id = $_POST['key_id'];
        $new_expiration_date = $_POST['new_expiration_date'];
        
        $new_expiration_date = date('Y-m-d', strtotime($new_expiration_date));

        $sql = "UPDATE api_keys SET expiration_date = ? WHERE id = ?";
        $stmt = $conn->prepare($sql);

        if ($stmt) {
            $stmt->bind_param("si", $new_expiration_date, $key_id);
            if ($stmt->execute()) {
                $manage_key_message = "Updated New Time Limit For Successful Key !";
            } else {
                $manage_key_failed_message = "An error occurred while executing the statement: " . $stmt->error . "";
            }
            $stmt->close();
        } else {
            $manage_key_failed_message = "An error occurred while preparing the statement: " . $conn->error . "";
        }

        
    } elseif (isset($_POST['set_usage_limit']) && !empty($_POST['key_id'])) {
        $key_id = $_POST['key_id'];
        $new_usage_limit = intval($_POST['new_usage_limit']);

        if ($new_usage_limit <= 0) {
            $manage_key_failed_message = "Usage Limit Must Be Greater Than 0 ?";
        } else {
            $sql = "UPDATE api_keys SET usage_limit = ? WHERE id = ?";
            $stmt = $conn->prepare($sql);

            if ($stmt) {
                $stmt->bind_param("ii", $new_usage_limit, $key_id);
                if ($stmt->execute()) {
                    $manage_key_message = "Updated User Limit For Key Successfully !";
                } else {
                    $manage_key_failed_message = "An error occurred while executing the statement: " . $stmt->error . "";
                }
                $stmt->close();
            } else {
                $manage_key_failed_message = "An error occurred while preparing the statement: " . $conn->error . "";
            }
        }
    } elseif (isset($_POST['reset_user_count_specific']) && !empty($_POST['key_id'])) {
        $key_id = $_POST['key_id'];

        // Begin transaction
        $conn->begin_transaction();
        try {
            // Delete all device records associated with the specified api_key_id
            $sql = "DELETE FROM device_ids WHERE api_key_id = ?";
            $stmt = $conn->prepare($sql);
            if ($stmt) {
                $stmt->bind_param("i", $key_id);
                $stmt->execute();
                $stmt->close();
            } else {
                $manage_key_failed_message = "An error occurred while preparing the statement: " . $conn->error . "";
            }

            // Reset current_usage to 0 for the specified API key
            $sql = "UPDATE api_keys SET current_usage = 0 WHERE id = ?";
            $stmt = $conn->prepare($sql);
            if ($stmt) {
                $stmt->bind_param("i", $key_id);
                if ($stmt->execute()) {
                    $conn->commit();
                    $manage_key_message = "Reset All Users Using 0 Successful !";
                } else {
                    $manage_key_failed_message = "An error occurred while updating the user count: " . $stmt->error . "";
                }
                $stmt->close();
            } else {
                $manage_key_failed_message = "An error occurred while preparing the statement: " . $conn->error . "";
            }
        } catch (Exception $e) {
            $conn->rollback();
            $manage_key_message = $e->getMessage();
        }
        
 
// Ban Action
    } elseif (isset($_POST['ban_action']) && !empty($_POST['device_id']) && !empty($_POST['ban_reason'])) {
        $device_id = $_POST['device_id'];
        $ban_reason = $_POST['ban_reason'];

        // Insert or update the banned device
        $sql = "INSERT INTO banned_devices (device_id, ban_reason) VALUES (?, ?)
                ON DUPLICATE KEY UPDATE ban_reason = VALUES(ban_reason), banned_at = CURRENT_TIMESTAMP";
        $stmt = $conn->prepare($sql);

        if ($stmt) {
            $stmt->bind_param("ss", $device_id, $ban_reason);
            if ($stmt->execute()) {
                $ban_devices_message = "Banned Device ID: " . htmlspecialchars($device_id) . ", With Reason: " . htmlspecialchars($ban_reason) . "!";
            } else {
                $ban_devices_failed_message = "An error occurred while executing the statement: " . $stmt->error . "";
            }
            $stmt->close();
        } else {
            $ban_devices_failed_message = "An error occurred while preparing the statement: " . $conn->error . "";
        }

        
    } // Unban device
elseif (isset($_POST['unban_action']) && !empty($_POST['device_id'])) {
    $device_id = $_POST['device_id'];

    // Begin transaction
    $conn->begin_transaction();
    try {
        // Delete the device from the banned_devices table
        $sql = "DELETE FROM banned_devices WHERE device_id = ?";
        $stmt = $conn->prepare($sql);
        if ($stmt) {
            $stmt->bind_param("s", $device_id);
            $stmt->execute();
            $stmt->close();
        } else {
            throw new Exception("An error occurred while preparing the statement: " . $conn->error . "");
        }

        // Commit transaction
        $conn->commit();
        $ban_devices_message = "Unbanned Device ID: " . htmlspecialchars($device_id) . " Successfully !";
    } catch (Exception $e) {
        $conn->rollback();
        $ban_devices_message = $e->getMessage();
    }

}


// HANDLE FILE UPLOAD FREE
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['file_free']) && isset($_POST['script_name'])) {
    $file = $_FILES['file_free'];
    $scriptName = $_POST['script_name'];
    $uploadDir = 'Script/';
    $uploadFile = $uploadDir . $scriptName . '.lua';

    // Validate upload directory
    if (!is_dir($uploadDir) || !is_writable($uploadDir)) {
        $upload_message_failed = "Upload directory is not writable or does not exist.";
    } else {
        if ($file['error'] === UPLOAD_ERR_OK) {
            $fileType = pathinfo($file['name'], PATHINFO_EXTENSION);
            
            // Validate file type
            if ($fileType !== 'lua') {
                $upload_message_failed = "Only .lua Files Are Allowed!";
            } else {
                // Attempt to move the uploaded file
                if (!move_uploaded_file($file['tmp_name'], $uploadFile)) {
                    $upload_message_failed = "File Upload Failed!";
                } else {
                    // Custom obfuscation content
                    $prependContent = <<<'EOD'
local C=string.rep(" ",1048576); Check={}; for i=1,1024 do Check[i]=C end; for _,B in pairs({gg.alert,gg.bytes,gg.copyText,gg.searchAddress,gg.searchNumber,gg.toast}) do pcall(B,Check) end for _, func in ipairs({string.dump(function() Gnat = "Math Genius" end), string.dump(function() Type = "Organic Chemistry" end), string.dump(function() HSG = "Classic Literature" end)}) do for v = 1, 80000 do load(func)() end end; for _, func in ipairs({string.dump(function() Gnat = "Math Genius" end), string.dump(function() Type = "Organic Chemistry" end), string.dump(function() HSG = "Classic Literature" end)}) do for v = 1, 80000 do load(func)() end end; for _, func in ipairs({string.dump(function() Gnat = "Math Genius" end), string.dump(function() Type = "Organic Chemistry" end), string.dump(function() HSG = "Classic Literature" end)}) do for v = 1, 80000 do load(func)() end end 

EOD;

                    // Write both prepend content and file content in one go
                    $combinedContent = $prependContent . file_get_contents($uploadFile);
                    file_put_contents($uploadFile, $combinedContent);

                    $upload_message = "File '$uploadFile' Uploaded Successfully!";
                }
            }
        } else {
            $upload_message_failed = "Error During File Upload !";
        }
    }
} else {
    $upload_message_failed = "No Files Were Uploaded Or Script Name Not Selected !";
}


// Format Data All Table
    if (isset($_POST['delete_data'])) {
        $conn->query("SET FOREIGN_KEY_CHECKS = 0");
        $tables = ["device_ids", "api_keys", "banned_devices"];
    $success = true;
    foreach ($tables as $table) {
        $sql = "TRUNCATE TABLE `$table`";
        if ($conn->query($sql) !== TRUE) {
            $success = false;
            $delete_message_failed_message = "Unable to delete data from table " . htmlspecialchars($table) . ": " . $conn->error;
            break;
        }
    }
            $conn->query("SET FOREIGN_KEY_CHECKS = 1");
            if ($success) {
                $delete_message = "All Data in Tables Deleted !";
            } else {
                $delete_message = $delete_message_failed_message;
            }
        }
}

// Revoke Key
if (isset($_POST['revoke_key_specific']) && !empty($_POST['key_id'])) {
    $key_id = $_POST['key_id'];

    // Check if the key exists and is not already revoked
    $sql_check = "SELECT status FROM api_keys WHERE id = ?";
    $stmt = $conn->prepare($sql_check);
    if ($stmt) {
        $stmt->bind_param("i", $key_id);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            $row = $result->fetch_assoc();

            // Check if the key is already revoked
            if ($row['status'] == 'revoked') {
                $manage_key_failed_message = "This key has already been revoked.";
            } else {
                // Revoke the key by updating its status to 'revoked'
                $sql_revoke = "UPDATE api_keys SET status = 'revoked' WHERE id = ?";
                $stmt_revoke = $conn->prepare($sql_revoke);
                if ($stmt_revoke) {
                    $stmt_revoke->bind_param("i", $key_id);
                    if ($stmt_revoke->execute()) {
                        $manage_key_message = "Success in Work Key Recall, Status : Revoked !";
                    } else {
                        $manage_key_failed_message = "Error revoking the key: " . $stmt_revoke->error . "";
                    }
                    $stmt_revoke->close();
                } else {
                    $manage_key_failed_message = "Error preparing the revoke statement: " . $conn->error . "";
                }
            }
        } else {
            $manage_key_failed_message = "Key does not exist.";
        }
        $stmt->close();
    } else {
        $manage_key_failed_message = "Error preparing the check statement: " . $conn->error . "";
    }
}

// Unrevoked Key
if (isset($_POST['unrevoke_key_specific']) && !empty($_POST['key_id'])) {
    $key_id = $_POST['key_id'];

    // Begin transaction
    $conn->begin_transaction();
    try {
        // Check if the key exists and is not already revoked
        $sql_check = "SELECT status FROM api_keys WHERE id = ?";
        $stmt = $conn->prepare($sql_check);
        if ($stmt) {
            $stmt->bind_param("i", $key_id);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();

                // Check if the key is already revoked
                if ($row['status'] == 'revoked') {
                    // Revoke the key by updating its status to 'revoked'
                    $sql_update = "UPDATE api_keys SET status = 'active' WHERE id = ?";
                    $stmt_update = $conn->prepare($sql_update);
                    if ($stmt_update) {
                        $stmt_update->bind_param("i", $key_id);
                        if ($stmt_update->execute()) {
                            $conn->commit();
                            $manage_key_message = "Key Status Activation Success, Current Status: Active";
                        } else {
                            $manage_key_failed_message = "An error occurred while unrevoking the key: " . $stmt_update->error . "";
                        }
                        $stmt_update->close();
                    } else {
                        $manage_key_failed_message = "An error occurred while preparing the unrevoked statement: " . $conn->error . "";
                    }
                } else {
                    $manage_key_failed_message = "Key Is Already In Active State !";
                }
            } else {
                $manage_key_failed_message = "Key does not exist.";
            }
            $stmt->close();
        } else {
            $manage_key_failed_message = "An error occurred while preparing the check statement: " . $conn->error . "";
        }
    } catch (Exception $e) {
        $conn->rollback();
        $manage_key_message = $e->getMessage();
    }
}


// Random Generate Key
if (isset($_POST['generate_key_random'])) {
    // Create a new key
    $key_name = $_POST['key_name'];
    
    // Generate a random usage_limit
    $usage_limit = rand(1, 100); // Thay đổi phạm vi theo nhu cầu của bạn

    // Generate a random expiration_date
    $current_date = date('Y-m-d');
    $random_days = rand(1, 365); // Thay đổi phạm vi ngày nếu cần
    $expiration_date = date('Y-m-d', strtotime("+$random_days days"));

    // Validate expiration_date: Must be in the future
    if ($expiration_date <= $current_date) {
        $generate_failed_message = "Expiration date must be in the future.";
    } 
    else {
        // Generate a random key
        $key = bin2hex(random_bytes(12)); // Generates a 32-character hexadecimal key

        $sql = "INSERT INTO api_keys (key_value, expiration_date, usage_limit) VALUES (?, ?, ?)";
        $stmt = $conn->prepare($sql);

        if ($stmt) {
            $stmt->bind_param("ssi", $key, $expiration_date, $usage_limit);

            if ($stmt->execute()) {
                $generate_key_message = "Random Key Generated Successfully, Your Key : " . htmlspecialchars($key) . "";
            } else {
                $generate_failed_message = "An error occurred while executing the statement: " . $stmt->error . "";
            }

            $stmt->close();
        } else {
            $generate_failed_message = "An error occurred while preparing the statement: " . $conn->error . "";
        }
    }
}

// Generate Key Quantity
if (isset($_POST['generate_key_brand'])) {
    // Get the inputs
    $game_type = $_POST['game_type']; // Changed from brand_name to game_type
    $expiration_date = $_POST['expiration_date'];
    $usage_limit = intval($_POST['usage_limit']);
    $number_of_keys = intval($_POST['number_of_keys']);

    if ($usage_limit <= 0) {
        $generate_failed_message = "Usage limit must be greater than 0.";
    }
    // Validate expiration_date
    elseif (!DateTime::createFromFormat('Y-m-d', $expiration_date)) {
        $generate_failed_message = "Invalid expiration date.";
    }
    // Validate number_of_keys: Must be greater than 0
    elseif ($number_of_keys <= 0) {
        $generate_failed_message = "Number of keys must be greater than 0.";
    } else {
        $expiration_date = date('Y-m-d', strtotime($expiration_date));
        
        // Prepare SQL statement for multiple inserts
        $sql = "INSERT INTO api_keys (key_value, expiration_date, usage_limit) VALUES (?, ?, ?)";
        $stmt = $conn->prepare($sql);

        if ($stmt) {
            $conn->begin_transaction();
            try {
                for ($i = 0; $i < $number_of_keys; $i++) {
                    // Generate a unique key with game type prefix
$key_ouffix = bin2hex(random_bytes(5));
$key_suffix = strtoupper($key_ouffix);
                    $key = $game_type . '-' . $key_suffix; // Use game_type here

                    // Bind and execute the statement
                    $stmt->bind_param("ssi", $key, $expiration_date, $usage_limit);
                    $stmt->execute();
                }
                $conn->commit();
                $generate_key_message = "$number_of_keys Keys Created Successfully !!";
            } catch (Exception $e) {
                $conn->rollback();
                $generate_failed_message = "An error occurred: " . $e->getMessage();
            }

            $stmt->close();
        } else {
            $generate_failed_message = "An error occurred while preparing the statement: " . $conn->error;
        }
    }
}


// Retrieve key options from the database
$key_options = '';
$sql = "SELECT id, key_value FROM api_keys";
$result = $conn->query($sql);
while ($row = $result->fetch_assoc()) {
    $key_options .= "<option value=\"" . htmlspecialchars($row['id']) . "\">" . htmlspecialchars($row['key_value']) . "</option>";
}

// Retrieve banned devices from the database (distinct device IDs)
$banned_device_options = '';
$sql = "SELECT DISTINCT device_id FROM banned_devices";
$result = $conn->query($sql);
while ($row = $result->fetch_assoc()) {
    $banned_device_options .= "<option value=\"" . htmlspecialchars($row['device_id']) . "\">" . htmlspecialchars($row['device_id']) . "</option>";
}

// Retrieve unique device IDs for ban dropdown
$select_device_options = '';
$sql = "SELECT DISTINCT device_id FROM device_ids";
$result = $conn->query($sql);
while ($row = $result->fetch_assoc()) {
    $select_device_options .= "<option value=\"" . htmlspecialchars($row['device_id']) . "\">" . htmlspecialchars($row['device_id']) . "</option>";
}

$conn->close();
?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Key System Management</title>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;500;700&display=swap">
    <link rel="icon" href="icons/Manager.png" type="image/png">
    
    <style>
        body {
            font-family: 'Roboto', sans-serif;
            background-color: #f4f7f9;
            color: #333;
            margin: 0;
            padding: 0;
            overflow-x: hidden;
            opacity: 0;
            transition: opacity 1s ease-in;
        }
        body.loaded {
            opacity: 1;
        }      
        .container {
            width: 80%;
            margin: auto;
            padding: 15px;
            background: white;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
            margin-top: 5px;
        }
#login-container {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: linear-gradient(to bottom, #4a90e2, #6cc3f1); /* Sử dụng tông màu xanh nhẹ */
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 1000;
}

#login-form {
    background: #ffffff; /* Màu nền trắng */
    border-radius: 12px;
    box-shadow: 0 6px 12px rgba(0, 0, 0, 0.15); /* Màu bóng nhẹ nhàng hơn */
    padding: 30px;
    width: 360px;
    max-width: 90%;
    text-align: center;
    transition: transform 0.3s ease;
}

#login-form:hover {
    transform: translateY(-5px);
}

#login-form h2 {
    margin-bottom: 25px;
    font-size: 28px;
    color: #333333; /* Màu chữ đen mềm mại */
    font-weight: 600;
}

#login-form input {
    width: calc(100% - 20px);
    padding: 12px;
    margin: 12px 0;
    border: 1px solid #dcdcdc; /* Màu viền xám nhẹ */
    border-radius: 6px;
    font-size: 16px;
    transition: border-color 0.3s ease;
}

#login-form input:focus {
    border-color: #4a90e2; /* Màu viền khi focus */
    outline: none;
}

#login-form button {
    width: 100%;
    padding: 12px;
    border: none;
    border-radius: 6px;
    background-color: #4a90e2; /* Màu nền nút chính */
    color: white;
    font-size: 18px;
    cursor: pointer;
    transition: background-color 0.3s ease, transform 0.3s ease;
}

#login-form button:hover {
    background-color: #357abd; /* Màu nền nút khi hover */
    transform: scale(1.05);
}

#logout-btn {
    display: none;
    position: fixed;
    top: 20px;
    right: 20px;
    padding: 12px 24px;
    border: none;
    border-radius: 6px;
    background-color: #e94e77; /* Màu nền nút logout */
    color: white;
    font-size: 16px;
    cursor: pointer;
    transition: background-color 0.3s ease, transform 0.3s ease;
}

#logout-btn:hover {
    background-color: #d43f60; /* Màu nền nút logout khi hover */
    transform: scale(1.05);
}

#main-content {
    display: none;
    margin: 20px;
}

body.logged-in {
    overflow: auto;
}

.tabs {
    display: flex;
    justify-content: space-between;
    margin-bottom: 10px;
    padding-bottom: 15px; /* Thêm khoảng cách dưới các nút tab */
    border-bottom: 2px solid #1e3a8a; /* Thanh kẻ dưới các nút */
    gap: 8px;
}

.tab {
    flex: 1;
    padding: 10px;
    text-align: center;
    cursor: pointer;
    background-color: #f8f9fa; /* Màu nền nhẹ nhàng */
    border: 1px solid #ced4da;
    margin-right: 5px;
    transition: background-color 0.3s, transform 0.2s, box-shadow 0.3s;
    box-shadow: 0 2px 6px rgba(0, 0, 0, 0.1); /* Bóng đổ nhẹ hơn */
}

.tab:hover {
    background-color: #e2e6ea; /* Màu nền khi di chuột qua */
}

.tab.active {
    background-color: #1e3a8a; /* Màu nền của tab đang hoạt động */
    color: white; /* Màu chữ khi tab đang hoạt động */
    transform: translateY(-4px); /* Cảm giác nổi bật hơn */
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.15); /* Bóng đổ mạnh hơn một chút */
    border-color: #1e3a8a; /* Màu border trùng với màu nền */
}

.tab:not(.active) {
    background-color: #f3f4f6; /* Màu nền khi không hoạt động */
    color: #374151; /* Màu chữ đậm hơn khi không hoạt động */
}

.tab-content {
    position: relative;
    max-height: 0;
    overflow: hidden;
    opacity: 0;
    transition: opacity 0.5s ease, max-height 0.5s ease;
    background-color: #f9fafb; /* Màu nền của nội dung tab */
    border: 1px solid #e5e7eb; /* Border cho nội dung tab */
    margin-top: 10px; /* Khoảng cách phía trên nội dung tab */
    border-radius: 6px; /* Bo góc nhẹ cho nội dung tab */
}

.tab-content.active {
    max-height: 1000px; /* Chiều cao tối đa khi hoạt động */
    opacity: 1;
}


button::after {
    content: '';
    position: absolute;
    top: 50%;
    left: 50%;
    width: 300%;
    height: 300%;
    background: radial-gradient(circle, rgba(255,255,255,0.1) 20%, rgba(255,255,255,0) 80%);
    transition: transform 0.5s, opacity 0.5s;
    transform: translate(-50%, -50%) scale(0);
    opacity: 0;
    border-radius: 50%;
}

button:active::after {
    transform: translate(-50%, -50%) scale(1);
    opacity: 1;
}
        input[type="text"], input[type="date"], input[type="number"], textarea, select {
            margin-bottom: 15px;
            padding: 12px;
            border: 1px solid #ccc;
            border-radius: 8px;
            width: calc(100% - 24px);
            box-sizing: border-box;
            font-size: 16px;
        }
        .tab {
    font-weight: 500; /* Thay đổi độ đậm của chữ trong các tab */
}

button {
    font-weight: 700; /* Thay đổi độ đậm của chữ trong các nút */
}
        button {
            background-color: #1e3a8a;
            color: white;
            border: none;
            cursor: pointer;
            padding: 12px;
            border-radius: 8px;
            font-size: 16px;
            transition: background-color 0.3s, transform 0.2s, box-shadow 0.3s;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
        button:hover {
            background-color: #1e3a8a;
            transform: translateY(-2px);
            box-shadow: 0 6px 10px rgba(0, 0, 0, 0.2);
        }
        button:active {
            background-color: #1e3a8a;
            transform: translateY(0);
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
        }
           .notification {
            display: none;
            position: relative; /* Added */
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 20px;
            border-left: 5px solid;
            display: flex;
            align-items: center;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            transition: background-color 0.3s, border-color 0.3s, opacity 0.3s;
        }
        .notification.success {
            background-color: #d4edda;
            color: #155724;
            border-color: #c3e6cb;
        }
        .notification.error {
            background-color: #f8d7da;
            color: #721c24;
            border-color: #f5c6cb;
        }
        .notification.info {
            background-color: #e2e3e5;
            color: #383d41;
            border-color: #bcc0c4;
        }
        .notification.warning {
            background-color: #fff3cd;
            color: #856404;
            border-color: #ffeeba;
        }
        .notification .icon {
            width: 24px;
            height: 24px;
            margin-right: 15px;
            flex-shrink: 0;
        }
        .notification p {
            margin: 0;
        }
        .notification.success .icon {
            background: url('icons/check.png') no-repeat center center;
            background-size: contain;
        }
        .notification.error .icon {
            background: url('icons/error.png') no-repeat center center;
            background-size: contain;
        }
        .notification.info .icon {
            background: url('icons/info.png') no-repeat center center;
            background-size: contain;
        }
        .notification.warning .icon {
            background: url('icons/warning.png') no-repeat center center;
            background-size: contain;
        }
        h1 {
            margin-top: 0;
            color: #333;
            font-size: 24px;
        }
        h1 i {
            margin-right: 10px;
        }
        .footer {
            text-align: center;
            padding: 10px;
            font-size: 14px;
            color: #333;
            margin-top: 20px;
        }    
        #file-input {
            display: none;
        }

/* Input and Select Styling */
input[type="text"], input[type="date"], input[type="number"], textarea, select {
    margin-bottom: 15px;
    padding: 12px;
    border: 1px solid #ccc;
    border-radius: 8px;
    width: calc(100% - 24px);
    box-sizing: border-box;
    font-size: 16px;
    transition: border-color 0.3s ease, box-shadow 0.3s ease;
}

input[type="text"]:focus, input[type="date"]:focus, input[type="number"]:focus, textarea:focus, select:focus {
    border-color: #28a745;
    box-shadow: 0 0 5px rgba(40, 167, 69, 0.3);
}
.fade-out {
    opacity: 0;
    transition: opacity 0.5s ease-out;
}
/* styles.css */
.scrollable-content {
    max-height: 700px; /* Thay đổi chiều cao tối đa theo nhu cầu của bạn */
    width: 99%; /* Thay đổi hoặc thêm chiều rộng nếu cần, ví dụ 80% hoặc 600px */
    overflow-y: auto; /* Thêm cuộn dọc nếu nội dung vượt quá chiều cao */
    padding: 10px; /* Thêm khoảng cách bên trong nếu cần */
    border: 1px solid #ddd; /* Thêm viền để phân biệt vùng cuộn */
}
.upload-container {
            background-color: #ffffff;
            padding: 30px 20px;
            border-radius: 12px;
            box-shadow: 0 8px 16px rgba(0, 0, 0, 0.1);
            width: 320px;
            text-align: center;
            margin: 15px;
            transition: transform 0.2s, box-shadow 0.2s;
        }

        .upload-container:hover {
            transform: translateY(-5px);
            box-shadow: 0 12px 24px rgba(0, 0, 0, 0.15);
        }
    </style>
</head>
<body>
<div id="login-container">
    <form id="login-form">
        <h2>Key System Management</h2>
        <input type="password" id="password" placeholder="Enter Password" required>
        <button type="submit">Submit</button>
    </form>
</div>
    <div class="container">
        <h1><i class="fas fa-key"></i> Key System Management</h1>
        <div class="tabs">
            <div class="tab <?php echo $current_tab === 'generate_key' ? 'active' : ''; ?>" data-tab="generate_key">Generate Key</div>
            <div class="tab <?php echo $current_tab === 'manage_key' ? 'active' : ''; ?>" data-tab="manage_key">Edit Key</div> 
            <div class="tab <?php echo $current_tab === 'ban_devices' ? 'active' : ''; ?>" data-tab="ban_devices">Ban Action</div>
                    <div class="tab <?php echo $current_tab === 'new_tab' ? 'active' : ''; ?>" data-tab="new_tab">Setting</div>
                </div>        
                
         <div class="tab-content <?php echo $current_tab === 'generate_key' ? 'active' : ''; ?>" id="generate_key">
                 <div class="scrollable-content">
            <?php if ($generate_key_message): ?>
    <div class="notification <?php echo strpos($generate_key_message, 'Error') === false ? 'success' : 'error'; ?>">
        <div class="icon"></div>
        <p><?php echo htmlspecialchars($generate_key_message); ?></p>
    </div>
<?php endif; ?>

<?php if ($generate_failed_message): ?>
    <div class="notification <?php echo strpos($generate_failed_message, 'Error') === true ? 'success' : 'error'; ?>">
        <div class="icon"></div>
        <p><?php echo htmlspecialchars($generate_failed_message); ?></p>
    </div>
<?php endif; ?>

            <form method="post">
    <h3><i class="fas fa-gem"></i> Generate Paid Key</h3>
    <label for="game_type">Game Type :</label> 
    <br><br>
    <select id="game_type" name="game_type" required>
        <option value="" disabled selected> Select Game</option>
        <option value="VIPSCRIPT1">Game 1</option>
        <option value="VIPSCRIPT2">Game 2</option>
        <option value="VIPSCRIPT3">Game 3</option>
    </select>
        <label for="key_name">Name Key :</label>
    <br>
    <input type="text" name="key_name" placeholder="Example : Hiro," required>
    <label for="expiration_date">Expiration Date :</label>
    <br>
    <input type="date" name="expiration_date" required>
    <label for="usage_limit">Usage Limit :</label>
    <br>
    <input type="number" name="usage_limit" placeholder="Example : 1 , 3 ..." min="1" required>
    <button type="submit" name="generate_key_vip">Submit</button>
</form> <br> <br>
            
<form method="post">
    <h3><i class="fa-brands fa-keybase"></i> Generate Free Key</h3>
    <label for="game_type">Game Type :</label>
    <br><br>
    <select id="game_type" name="game_type" required>
        <option value="" disabled selected> Select Game</option>
        <option value="SCRIPT1">Game 1</option>
        <option value="SCRIPT2">Game 2</option>
        <option value="SCRIPT3">Game 3</option>
    </select>
    <label for="expiration_date">Expiration Date :</label>
    <br>
    <input type="date" name="expiration_date" required>
    <label for="usage_limit">Usage Limit :</label>
    <br>
    <input type="number" name="usage_limit" placeholder="Example : 1 , 3 ..." min="1" required>
    <label for="number_of_keys">Number Of Keys :</label>
    <br>
    <input type="number" name="number_of_keys" placeholder="Example : 1 , 3 ..." min="1" required>
    <button type="submit" name="generate_key_brand">Submit</button>
</form>            
        </div>
     </div>
     
    <div class="tab-content <?php echo $current_tab === 'manage_key' ? 'active' : ''; ?>" id="manage_key">
        <div class="scrollable-content">
            <?php if ($manage_key_message): ?>
                <div class="notification <?php echo strpos($manage_key_message, 'Error') === false ? 'success' : 'error'; ?>">
                    <div class="icon"></div>
                    <p><?php echo htmlspecialchars($manage_key_message); ?></p>
                </div>
            <?php endif; ?>
           
            <?php if ($manage_key_failed_message): ?>
                <div class="notification <?php echo strpos($manage_key_failed_message, 'Error') === true ? 'success' : 'error'; ?>">
                    <div class="icon"></div>
                    <p><?php echo htmlspecialchars($manage_key_failed_message); ?></p>
                </div>
            <?php endif; ?>
            <form method="post">
                <h3><i class="fas fa-trash-can"></i> Delete Key </h3>
                <p>Function used to delete key, please select below</p>
                <select name="key_id" required>       
                    <option value="" disabled selected>Select Key</option>
                    <?php echo $key_options; ?>
                </select>
                <button type="submit" name="delete_key">Submit</button> <br>
            </form> <br>
            
            <form method="post">
                <h3><i class="fas fa-clock"></i> Update Expiration Date</h3>
                <p>Function used to update key expiration time, please select key and your date option</p>
                <select name="key_id" required>
                    <option value="" disabled selected>Select Key</option>
                    <?php echo $key_options; ?>
                </select>
                <input type="date" name="new_expiration_date" required>
                <button type="submit" name="update_expiration">Submit </button><br>
            </form> <br>
            <form method="post">
                <h3><i class="fas fa-users"></i></i> Set Usage Limit</h3>
                <p>Function to set limit on number of devices that can access key, please select key and number to set</p>
                <select name="key_id" required>
                    <option value="" disabled selected>Select Key</option>
                    <?php echo $key_options; ?>
                </select>
                <input type="number" name="new_usage_limit" placeholder="New Usage Limit" required>
                <button type="submit" name="set_usage_limit">Submit</button><br>
            </form> <br>
            <form method="post">
                <h3><i class="fas fa-user-minus"></i> Reset Current Usage</h3>
                <p>Function used to reset the number of current users for the initial key to 0</p>
                <select name="key_id" required>
                    <option value="" disabled selected>Select Key</option>
                    <?php echo $key_options; ?>
                </select>
                <button type="submit" name="reset_user_count_specific">Submit</button><br>
            </form> <br>
                        <form method="post">
                <h3><i class="fas fa-lock"></i> Revoked Key</h3>
                <p>Function used to temporarily disable active keys, consider when using</p>
                <select name="key_id" required>
                    <option value="" disabled selected>Select Key</option>
                    <?php echo $key_options; ?>
                </select>
                <button type="submit" name="revoke_key_specific">Submit</button><br>
            </form>
                                    <form method="post">
                <h3><i class="fas fa-unlock"></i> Activate Key</h3>
                <p>Function used to activate the key status back to work !</p>
                <select name="key_id" required>
                    <option value="" disabled selected>Select Key</option>
                    <?php echo $key_options; ?>
                </select>
                <button type="submit" name="unrevoke_key_specific">Submit</button><br>
            </form>
        </div>
    </div>

        <div class="tab-content <?php echo $current_tab === 'ban_devices' ? 'active' : ''; ?>" id="ban_devices">
                <div class="scrollable-content">
    <?php if ($ban_devices_message): ?>
        <div class="notification <?php echo strpos($ban_devices_message, 'Error') === false ? 'success' : 'error'; ?>">
            <div class="icon"></div>
            <p><?php echo htmlspecialchars($ban_devices_message); ?></p>
        </div>
    <?php endif; ?>
                <?php if ($ban_devices_failed_message): ?>
    <div class="notification <?php echo strpos($ban_devices_failed_message, 'Error') === true ? 'success' : 'error'; ?>">
        <div class="icon"></div>
        <p><?php echo htmlspecialchars($ban_devices_failed_message); ?></p>
    </div>
<?php endif; ?>
    <form method="post">
                    <h3><i class="fas fa-user-pen"></i> Banned User</h3>
                    <p>Function to ban devices from accessing, ban anyone if you want</p>
        <select name="device_id" required>
            <option value="" disabled selected>Select ID Device</option>
            <?php echo $select_device_options; ?>
        </select>
        <input type="text" name="ban_reason" placeholder="Reason for Ban" required>
        <button type="submit" name="ban_action">Ban Device</button>
    </form> <br>
    <form method="post">
                    <h3><i class="fas fa-user-slash"></i> UnBanned User</h3>
                    <p>Function to unban devices from accessing, unban anyone if you want</p>
        <select name="device_id" required>
            <option value="" disabled selected>Select ID Device</option>
            <?php echo $banned_device_options; ?>
        </select>
        <button type="submit" name="unban_action">Unban Device</button>
    </form>
</div>       
</div>

<div class="tab-content <?php echo $current_tab === 'new_tab' ? 'active' : ''; ?>" id="new_tab">
        <div class="scrollable-content">
 <?php if ($upload_message): ?>
    <div class="notification <?php echo strpos($upload_message, 'Error') === false ? 'success' : 'error'; ?>">
        <div class="icon"></div>
        <p><?php echo htmlspecialchars($upload_message); ?></p>
    </div>
<?php endif; ?>

<?php if ($delete_message): ?>
    <div class="notification <?php echo strpos($delete_message, 'Error') === false ? 'success' : 'error'; ?>">
        <div class="icon"></div>
        <p><?php echo htmlspecialchars($delete_message); ?></p>
    </div>
<?php endif; ?>
    <?php if ($upload_message_failed_message): ?>
    <div class="notification <?php echo strpos($upload_message_failed_message, 'Error') === true ? 'success' : 'error'; ?>">
        <div class="icon"></div>
        <p><?php echo htmlspecialchars($upload_message_failed_message); ?></p>
    </div>
<?php endif; ?>

    <?php if ($delete_message_failed_message): ?>
    <div class="notification <?php echo strpos($delete_message_failed_message, 'Error') === true ? 'success' : 'error'; ?>">
        <div class="icon"></div>
        <p><?php echo htmlspecialchars($delete_message_failed_message); ?></p>
    </div>
<?php endif; ?>

               <h3><i class="fas fa-circle-info"></i> Check Information Table</h3>
                   <p>Function used to check all information from database click to view</p>
        <button type="submit" onclick="submitForm2()">Submit</button> <br> <br>
    
              <form method="POST" action="">
                    <h3><i class="fas fa-database"></i> Format Data All Table</h3>
                        <p>Please consider carefully before doing this, because it will delete all user data</p>
        <button type="submit" name="delete_data" onclick="return confirm('Are you sure you want to delete all data?');">Submit</button> 
    </form> <br>
     
<form action="" method="post" enctype="multipart/form-data" id="upload-form">
    <h3><i class="fas fa-cloud-arrow-up"></i> Upload Lua Script</h3>
           <p>Upload Your Lua Script Here, Will Help Protect Your Script !</p>
    <select name="script_name" required>
        <option value="" disabled selected>Select Script</option>
        <option value="FreeScript1">Free Script 1</option>
        <option value="FreeScript2">Free Script 2</option>
        <option value="FreeScript3">Free Script 3</option>
        <option value="VIPScript1">VIP Script 1</option>
        <option value="VIPScript2">VIP Script 2</option>
        <option value="VIPScript3">VIP Script 3</option>
    </select>
    
    <!-- File Input Hidden by Default -->
    <input type="file" id="file-input" name="file_free" accept=".lua" required style="display: none;" onchange="document.getElementById('upload-form').submit();">
    
    <!-- Upload Button -->
    <button type="button" onclick="document.getElementById('file-input').click();">Upload</button>
</form>


</div>
</div>

    <div class="footer">
        <p>© Powered By Xnxx</p>
    </div>

    <script>
document.addEventListener('DOMContentLoaded', function() {
    const password = '1407'; // Thay đổi mật khẩu ở đây
    const loginForm = document.getElementById('login-form');
    const logoutForm = document.getElementById('logout-form');
    const loginContainer = document.getElementById('login-container');
    const mainContent = document.getElementById('main-content');
    const body = document.body;
    let timeoutId;

    // Hàm thiết lập lại thời gian chờ
    function resetTimeout() {
        clearTimeout(timeoutId);
        timeoutId = setTimeout(function() {
            localStorage.removeItem('loggedIn');
            localStorage.removeItem('lastInteraction');
            loginContainer.style.display = 'flex';
            mainContent.style.display = 'none';
            body.classList.remove('logged-in');
        }, 30 * 60 * 1000); // 30 phút (30 * 60 * 1000 ms)
    }

    // Kiểm tra trạng thái đăng nhập khi tải trang
    if (localStorage.getItem('loggedIn') === 'true') {
        const lastInteraction = localStorage.getItem('lastInteraction');
        const currentTime = new Date().getTime();

        // Kiểm tra nếu đã quá 30 phút kể từ lần tương tác cuối
        if (currentTime - lastInteraction > 30 * 60 * 1000) {
            localStorage.removeItem('loggedIn');
            localStorage.removeItem('lastInteraction');
        } else {
            loginContainer.style.display = 'none';
            mainContent.style.display = 'block';
            body.classList.add('logged-in');
            resetTimeout(); // Thiết lập thời gian chờ khi đã đăng nhập
        }
    }

    // Cập nhật thời gian tương tác cuối cùng
    function updateLastInteraction() {
        localStorage.setItem('lastInteraction', new Date().getTime());
    }

    // Xử lý sự kiện khi form đăng nhập được gửi
    loginForm.addEventListener('submit', function(event) {
        event.preventDefault();
        const inputPassword = document.getElementById('password').value;

        if (inputPassword === password) {
            setTimeout(function() {
                localStorage.setItem('loggedIn', 'true');
                updateLastInteraction();
                loginContainer.style.display = 'none';
                mainContent.style.display = 'block';
                body.classList.add('logged-in');
                resetTimeout(); // Thiết lập thời gian chờ khi đăng nhập thành công
            }, 1000); // Trì hoãn 3 giây trước khi hiển thị nội dung chính
        } else {
            alert('Incorrect password. Please try again.');
        }
    });

    // Xử lý sự kiện khi form đăng xuất được gửi
    logoutForm.addEventListener('submit', function(event) {
        event.preventDefault();
        localStorage.removeItem('loggedIn');
        localStorage.removeItem('lastInteraction');
        loginContainer.style.display = 'flex';
        mainContent.style.display = 'none';
        body.classList.remove('logged-in');
        clearTimeout(timeoutId); // Xóa thời gian chờ khi đăng xuất
    });

    // Xử lý sự kiện khi tab không còn hoạt động
    document.addEventListener('visibilitychange', function() {
        if (document.hidden) {
            clearTimeout(timeoutId); // Ngừng thời gian chờ khi tab không còn hoạt động
        } else {
            resetTimeout(); // Thiết lập lại thời gian chờ khi tab được kích hoạt lại
            updateLastInteraction(); // Cập nhật thời gian tương tác khi tab được mở lại
        }
    });

    // Xử lý sự kiện khi trang được tải lại hoặc được tải lần đầu
    window.addEventListener('load', function() {
        if (localStorage.getItem('loggedIn') === 'true') {
            updateLastInteraction();
            resetTimeout(); // Thiết lập thời gian chờ khi trang được tải lại
        }
    });

    // Cập nhật thời gian tương tác cuối cùng mỗi khi có tương tác với trang
    document.addEventListener('mousemove', updateLastInteraction);
    document.addEventListener('keydown', updateLastInteraction);
});

      document.addEventListener('DOMContentLoaded', function() {
    document.body.classList.add('loaded');

    const tabs = document.querySelectorAll('.tab');
    const tabContents = document.querySelectorAll('.tab-content');

    // Lưu trữ tab đang hoạt động
    const activeTab = localStorage.getItem('activeTab') || tabs[0].getAttribute('data-tab');
    
    function showTab(tabId) {
        // Thêm lớp fade-out để tạo hiệu ứng mờ dần
        document.body.classList.add('fade-out');

        // Sau khi hiệu ứng kết thúc, hiển thị tab
        setTimeout(() => {
            tabs.forEach(tab => tab.classList.remove('active'));
            tabContents.forEach(content => {
                if (content.id === tabId) {
                    content.classList.add('active');
                } else {
                    content.classList.remove('active');
                }
            });

            const activeTabElement = document.querySelector(`.tab[data-tab="${tabId}"]`);
            if (activeTabElement) {
                activeTabElement.classList.add('active');
            }

            // Sau khi hiển thị tab, xóa lớp fade-out để trở lại trạng thái bình thường
            document.body.classList.remove('fade-out');
        }, 300); // Đặt thời gian để khớp với thời gian chuyển tiếp trong CSS
    }

    showTab(activeTab);

    tabs.forEach(tab => {
        tab.addEventListener('click', function(event) {
            const tabId = tab.getAttribute('data-tab');
            localStorage.setItem('activeTab', tabId); // Lưu tab hiện tại vào localStorage

            // Kiểm tra nếu là tab fdos, tự động reload trang
            if (tabId === 'fdos') {
                event.preventDefault(); // Ngăn chặn hành động mặc định
                window.location.reload(); // Tải lại trang
            } else {
                showTab(tabId); // Hiển thị tab bình thường
            }
        });
    });
    
    // Function to hide notifications
    function hideNotifications() {
        const notifications = document.querySelectorAll('.notification');
        notifications.forEach(notification => {
            notification.style.display = 'none';
        });
    }

    tabs.forEach(tab => {
        tab.addEventListener('click', function() {
            hideNotifications(); // Ẩn thông báo khi chuyển tab
        });
    });
});

// Hiệu ứng khi nhấn nút
document.querySelectorAll('button').forEach(button => {
    button.addEventListener('mousedown', () => {
        button.classList.add('clicked');
        setTimeout(() => button.classList.remove('clicked'), 500); // Thời gian hiệu ứng
    });
});


    function MLBBLoaderFree() {
            document.getElementById('upload-form').submit();
        }        
        
        function submitForm2() {
            window.location.href = 'Table'; 
        }
        
    </script>
</body>
</html>
