<?php

// At the beginning of your PHP script
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Connect Database 
include 'Database.php';

// Existing script definitions
$FreeScript1 = 'Script/FreeScript1.lua'; 
$FreeScript2 = 'Script/FreeScript2.lua'; 
$FreeScript3 = 'Script/FreeScript3.lua'; 

$VIPScript1 = 'Script/VIPScript1.lua'; 
$VIPScript2 = 'Script/VIPScript2.lua'; 
$VIPScript3 = 'Script/VIPScript3.lua'; 

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('HTTP/1.0 403 Forbidden');
    echo "Access Denied";
    exit();
}

function exitAlert($msg) {
    exit("os.remove('/sdcard/Key.sh') gg.setVisible(true) print(' " . addslashes($msg) . " ')");
}

function exitAlert2($msg) {
    exit("gg.setVisible(true) print(' " . addslashes($msg) . " ')");
}

function logSuccessfulLogin($key_value, $scriptToRun, $device_id) {
    $logFile = 'Access_Log.txt'; 
    $ip_address = $_SERVER['REMOTE_ADDR'];
    $user_agent = $_SERVER['HTTP_USER_AGENT'] ?? '';

    // API Configuration
    $api_key = "a8318ebb828b842a852e442a07e8ad5b34525663f2996c6b877151e55a367101";
    $url = "https://proxycheck.io/v2/$ip_address?key=$api_key&vpn=1&asn=1";
    
    // Fetch IP Details
    $response = file_get_contents($url);
    $data = json_decode($response, true);

    // Check for JSON Decoding Errors
    if (json_last_error() !== JSON_ERROR_NONE) {
        exitAlert2("┇ Failed To Parse API Response, Please Try Again Later !");
    }

    // Extract Country and Region Information
    $country = isset($data[$ip_address]['country']) ? $data[$ip_address]['country'] : 'Unknown';
    $region = isset($data[$ip_address]['region']) ? $data[$ip_address]['region'] : 'Unknown';

    // Get Request Method
    $request_method = $_SERVER['REQUEST_METHOD'];

    // Create Log Entry
    $logEntry = sprintf(
        "────────────────────────\n".
        "Timestamp : %s\n".
        "Device ID : %s\n".
        "IP : %s | Country : %s | Region : %s\n".
        "User-Agent : %s\n".
        "Script : %s\n".
        "Method : %s\n".
        "────────────────────────\n\n",
        date('Y-m-d H:i:s'),
        $device_id,
        $ip_address,
        $country,
        $region,
        $user_agent,
        $scriptToRun,
        $request_method
    );

    // Read existing log file content
    $existingLogs = file_exists($logFile) ? file_get_contents($logFile) : '';

    // Remove existing log entry for this device ID
    $existingLogs = preg_replace("/^────────────────────────\nTimestamp : [^\n]*\nDevice ID : " . preg_quote($device_id, '/') . "[^\n]*\n.*?────────────────────────\n\n/sm", '', $existingLogs);

    // Append the new log entry
    $updatedLogs = $existingLogs . $logEntry;

    // Write updated logs to file
    file_put_contents($logFile, $updatedLogs);
}


// Check VPN or Proxy using proxycheck.io
$api_key = "a8318ebb828b842a852e442a07e8ad5b34525663f2996c6b877151e55a367101";
$ip_to_check = $_SERVER['REMOTE_ADDR'];

$url = "https://proxycheck.io/v2/$ip_to_check?key=$api_key&vpn=1&asn=1";
$response = file_get_contents($url);
$data = json_decode($response, true);

if (json_last_error() !== JSON_ERROR_NONE) {
    exitAlert2("┇ Failed To Parse API Response, Please Try Again Later !");
}

$vpn = isset($data[$ip_to_check]['proxy']) ? $data[$ip_to_check]['proxy'] === "yes" : false;

if ($vpn) {
    exitAlert2("┇ VPN Or Proxy Detected, Please Disable And Try Again !");
}


$conn->begin_transaction();

try {
    $key_input = $_POST['key'] ?? '';

    $stmt_key = $conn->prepare("SELECT id, usage_limit, expiration_date, current_usage, status FROM api_keys WHERE key_value = ?");
    if (!$stmt_key) throw new Exception("Error preparing statement: " . $conn->error);

    $stmt_key->bind_param("s", $key_input);
    $stmt_key->execute();
    $result_key = $stmt_key->get_result();

    if ($result_key->num_rows === 1) {
        $key_data = $result_key->fetch_assoc();
        $key_id = $key_data['id'];
        $expiration_date = $key_data['expiration_date'];
        $usage_limit = $key_data['usage_limit'];
        $current_usage = $key_data['current_usage'];
        $status = $key_data['status'];

        if ($status === 'revoked') {
            exitAlert2("┇ Current Key Has Been Revoked, So It Cannot Be Accessed Using This Key, Please Contact Publisher For Resolution !");
        }

        if ($status === 'expired' && new DateTime() < new DateTime($expiration_date)) {
            $stmt_update_status = $conn->prepare("UPDATE api_keys SET status = 'active' WHERE id = ?");
            if (!$stmt_update_status) throw new Exception("Error preparing status update statement: " . $conn->error);

            $stmt_update_status->bind_param("i", $key_id);
            $stmt_update_status->execute();
            $stmt_update_status->close();

            $status = 'active';
        }

        if ($status === 'active') {
            if (new DateTime() <= new DateTime($expiration_date)) {
                $hash = hash('sha256', $_SERVER['HTTP_USER_AGENT'] ?? '', true);
                $device_id = base_convert(bin2hex($hash), 16, 10); 
                $device_id = substr($device_id, 0, 24);

                $stmt_ban_check = $conn->prepare("SELECT * FROM banned_devices WHERE device_id = ?");
                if (!$stmt_ban_check) throw new Exception("Error preparing statement: " . $conn->error);

                $stmt_ban_check->bind_param("s", $device_id);
                $stmt_ban_check->execute();
                $result_ban = $stmt_ban_check->get_result();

                if ($result_ban->num_rows > 0) {
                    exitAlert("┇ Your Device ID Has Been Banned !");
                } else {
                    $stmt_device_check = $conn->prepare("SELECT number_key_id FROM device_ids WHERE device_id = ? AND api_key_id = ?");
                    if (!$stmt_device_check) throw new Exception("Error preparing statement: " . $conn->error);

                    $stmt_device_check->bind_param("si", $device_id, $key_id);
                    $stmt_device_check->execute();
                    $result_device_check = $stmt_device_check->get_result();

                    if ($result_device_check->num_rows > 0) {
                        $device_data = $result_device_check->fetch_assoc();
                        $number_key_id = $device_data['number_key_id'];

                        if ($number_key_id > $usage_limit) {
                            exitAlert("┇ This Key Has Reached Maximum Users !");
                        }
                    } else {
                        $stmt_number_key_id = $conn->prepare("SELECT IFNULL(MAX(number_key_id), 0) + 1 AS next_key_id FROM device_ids WHERE api_key_id = ?");
                        if (!$stmt_number_key_id) throw new Exception("Error preparing statement: " . $conn->error);

                        $stmt_number_key_id->bind_param("i", $key_id);
                        $stmt_number_key_id->execute();
                        $result_number_key_id = $stmt_number_key_id->get_result();
                        $number_key_id = $result_number_key_id->fetch_assoc()['next_key_id'];

                        if ($number_key_id > $usage_limit) {
                            exitAlert("┇ This Key Has Reached Maximum Users !");
                        }

                        $stmt_insert = $conn->prepare("INSERT INTO device_ids (device_id, api_key_id, number_key_id) VALUES (?, ?, ?)");
                        if (!$stmt_insert) throw new Exception("Error preparing statement: " . $conn->error);

                        $stmt_insert->bind_param("sii", $device_id, $key_id, $number_key_id);
                        $stmt_insert->execute();
                        $stmt_insert->close();
                    }

                    if ($number_key_id > $current_usage) {
                        $stmt_update_usage = $conn->prepare("UPDATE api_keys SET current_usage = ? WHERE id = ?");
                        if (!$stmt_update_usage) throw new Exception("Error preparing statement: " . $conn->error);

                        $stmt_update_usage->bind_param("ii", $number_key_id, $key_id);
                        $stmt_update_usage->execute();
                        $stmt_update_usage->close();
                    }

                    $stmt_remove_null_keys = $conn->prepare("DELETE FROM device_ids WHERE api_key_id IS NULL");
                    if (!$stmt_remove_null_keys) throw new Exception("Error preparing statement: " . $conn->error);

                    $stmt_remove_null_keys->execute();
                    $stmt_remove_null_keys->close();

                    $conn->commit();

                    if (strpos($key_input, 'SCRIPT1-') === 0) {
                        $scriptToRun = $FreeScript1;
                    } elseif (strpos($key_input, 'SCRIPT2-') === 0) {
                        $scriptToRun = $FreeScript2;
                    } elseif (strpos($key_input, 'SCRIPT3-') === 0) {
                        $scriptToRun = $FreeScript3;
                    } elseif (strpos($key_input, 'VIPSCRIPT1-') === 0) {
                        $scriptToRun = $VIPScript1;
                    } elseif (strpos($key_input, 'VIPSCRIPT2-') === 0) {
                        $scriptToRun = $VIPScript2;
                    } elseif (strpos($key_input, 'VIPSCRIPT3-') === 0) {
                        $scriptToRun = $VIPScript3;
                    } else {
                        exitAlert2("┇ Invalid Key Format");
                    }

                    if (file_exists($scriptToRun)) {
                        logSuccessfulLogin($key_id, $scriptToRun, $device_id);
                        exit(file_get_contents($scriptToRun));
                    } else {
                        exitAlert2("┇ Script Not Found In Server");
                    }
                }
            } else {
                $stmt_update_status = $conn->prepare("UPDATE api_keys SET status = 'expired' WHERE id = ?");
                if (!$stmt_update_status) throw new Exception("Error preparing status update statement: " . $conn->error);

                $stmt_update_status->bind_param("i", $key_id);
                $stmt_update_status->execute();

                if ($stmt_update_status->affected_rows === 0) {
                    error_log("Failed to update status for key ID: " . $key_id);
                }

                $stmt_update_status->close();

                $conn->commit();

                exitAlert("┇ Key Expired, Please Contact Publisher");
            }
        } else {
            exitAlert("┇ Invalid Key Status");
        }
    } else {
        exitAlert("┇ Wrong Key, Please Contact Publisher");
    }

    $stmt_key->close();
    $stmt_ban_check->close();
    $stmt_device_check->close();
    $stmt_number_key_id->close();
} catch (Exception $e) {
    $conn->rollback();
    error_log("Transaction error: " . $e->getMessage());
    exitAlert2("An error occurred. Please try again later.");
}

$conn->close();
?>
