<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Data Sheet</title>
    <!-- Link to Bootstrap CSS -->
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <!-- Link to FontAwesome for icons -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">
    <!-- Link to Google Fonts for Roboto -->
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <link rel="icon" href="icons/logo-table.svg" type="image/png">
    
    <style>
        html, body {
            height: 100%;
            margin: 0;
            font-family: 'Roboto', sans-serif;
        }
        body {
            background-color: #f8f9fa;
            padding-top: 20px;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }
        .container {
            flex: 1;
            margin-top: 20px;
            max-width: 1200px; /* Limit the maximum width for better readability */
        }
        .table-container {
            padding: 20px;
            background-color: white;
            border-radius: 10px; /* Rounded corners */
            box-shadow: 0 4px 12px rgba(0,0,0,0.3); /* Enhance shadow for prominence */
            margin-bottom: 20px;
        }
        .header {
            color: #333; /* Dark text color for better readability */
            padding: 15px;
            border-radius: 10px; /* Rounded corners */
            background-color: #e2f0e7; /* Light green background */
            text-align: center;
            position: relative;
            display: flex;
            align-items: center;
            box-shadow: 0 4px 12px rgba(0,0,0,0.3); /* Enhance shadow for prominence */
            margin-bottom: 20px;
        }
        .header i {
            position: absolute;
            left: 15px; /* Adjust the distance from the left edge */
            top: 50%;
            transform: translateY(-50%);
            font-size: 24px; /* Adjust icon size */
            color: #333; /* Dark icon color */
            padding: 10px; /* Adjust padding */
            background: none; /* Remove background */
        }
        .header h1 {
            margin: 0;
            padding-left: 50px; /* Adjust padding to align with icon */
            font-size: 1.5rem; /* Adjust font size */
            font-weight: 700; /* Make the title bold */
        }
        .table-responsive {
            overflow-x: auto;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 0.875rem; /* Reduce font size */
        }
        th, td {
            padding: 10px; /* Reduce padding */
            text-align: left;
            border-bottom: 1px solid #dee2e6;
        }
        th {
            background-color: #343a40;
            color: white;
            font-size: 0.875rem; /* Reduce font size */
        }
        tbody tr:hover {
            background-color: #f1f1f1;
        }
        .footer {
            color: #333333;
            text-align: center;
            padding: 20px;
            background-color: transparent; /* Remove background color */
            box-shadow: 0 -4px 8px rgba(0,0,0,0.2);
        }
        .footer p {
            margin: 0;
        }
        .back-button {
            position: fixed;
            bottom: 20px;
            right: 20px;
            padding: 12px 24px; /* Increased padding for better appearance */
            background-color: #007bff;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 1.1rem; /* Increased font size */
            font-weight: 700; /* Make font bold */
            box-shadow: 0 4px 8px rgba(0,0,0,0.3);
            transition: background-color 0.3s, transform 0.1s; /* Smooth transition */
        }
        .back-button:hover {
            background-color: #0056b3;
        }
        .back-button:active {
            transform: scale(0.95); /* Button shrink effect on click */
        }
    </style>
</head>
<body>

<div class="container">
    <!-- API Keys Table -->
    <div class="table-container">
        <div class="header">
            <i class="fas fa-key"></i> <!-- FontAwesome icon -->
            <h1>KEY LIST</h1>
        </div>

        <div class="table-responsive">
            <table class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Key</th>
                        <th>Expiration Date</th>
                        <th>Usage Limit</th>
                        <th>Current Usage</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    // Connect Database 
include 'Database.php';

                    // Set charset for the connection
                    $conn->set_charset("utf8mb4");

                    // Query data from api_keys table
                    $sql = "SELECT id, key_value, expiration_date, usage_limit, current_usage, status FROM api_keys";
                    $result = $conn->query($sql);

                    if ($result->num_rows > 0) {
                        // Display data row by row
                        while($row = $result->fetch_assoc()) {
                            echo "<tr>";
                            echo "<td>" . $row["id"] . "</td>";
                            echo "<td>" . $row["key_value"] . "</td>";
                            echo "<td>" . $row["expiration_date"] . "</td>";
                            echo "<td>" . $row["usage_limit"] . "</td>";
                            echo "<td>" . $row["current_usage"] . "</td>";
                            echo "<td>" . $row["status"] . "</td>";
                            echo "</tr>";
                        }
                    } else {
                        echo "<tr><td colspan='6' class='text-center'>No results found.</td></tr>";
                    }

                    // Close connection
                    $conn->close();
                    ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- BANNED DEVICES LIST -->
    <div class="table-container">
        <div class="header">
            <i class="fas fa-ban"></i> <!-- FontAwesome icon for banned devices -->
            <h1>BANNED DEVICES LIST</h1>
        </div>

        <div class="table-responsive">
            <table class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Device ID</th>
                        <th>Reason</th>
                        <th>Banned At</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    // Create a new connection for the banned_devices table
                    $conn = new mysqli($servername, $username, $password, $dbname);

                    // Check connection
                    if ($conn->connect_error) {
                        die("Connection failed: " . $conn->connect_error);
                    }

                    // Set charset for the connection
                    $conn->set_charset("utf8mb4");

                    // Query data from banned_devices table
                    $sql = "SELECT id, device_id, ban_reason, banned_at FROM banned_devices";
                    $result = $conn->query($sql);

                    if ($result === FALSE) {
                        echo "Error: " . $conn->error;
                    } elseif ($result->num_rows > 0) {
                        // Display data row by row
                        while($row = $result->fetch_assoc()) {
                            echo "<tr>";
                            echo "<td>" . $row["id"] . "</td>";
                            echo "<td>" . $row["device_id"] . "</td>";
                            echo "<td>" . $row["ban_reason"] . "</td>";
                            echo "<td>" . $row["banned_at"] . "</td>";
                            echo "</tr>";
                        }
                    } else {
                        echo "<tr><td colspan='4' class='text-center'>No results found.</td></tr>";
                    }

                    // Close connection
                    $conn->close();
                    ?>
                </tbody>
            </table>
        </div>
    </div>

   <!-- LIST DEVICE -->
<div class="table-container">
    <div class="header">
        <i class="fas fa-mobile-alt"></i> <!-- FontAwesome icon for device IDs -->
        <h1>ID DEVICES LIST</h1>
    </div>

    <div class="table-responsive">
        <table class="table table-striped table-bordered">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Device ID</th>
                </tr>
            </thead>
            <tbody>
                <?php
                // Create a new connection for the device_ids table
                $conn = new mysqli($servername, $username, $password, $dbname);

                // Check connection
                if ($conn->connect_error) {
                    die("Connection failed: " . $conn->connect_error);
                }

                // Set charset for the connection
                $conn->set_charset("utf8mb4");

                // Query unique device IDs from the device_ids table
                $sql = "SELECT DISTINCT device_id FROM device_ids";
                $result = $conn->query($sql);

                if ($result->num_rows > 0) {
                    $id = 1; // Initialize the ID counter
                    // Display unique data row by row
                    while($row = $result->fetch_assoc()) {
                        echo "<tr>";
                        echo "<td>" . $id++ . "</td>"; // Increment and display ID
                        echo "<td>" . $row["device_id"] . "</td>";
                        echo "</tr>";
                    }
                } else {
                    echo "<tr><td colspan='2' class='text-center'>No results found.</td></tr>";
                }

                // Close connection
                $conn->close();
                ?>
            </tbody>
        </table>
    </div>
</div>

    <!-- Footer -->
    <div class="footer">
        <p>&copy; Powered By Xnxx</p>
    </div>
</div>

<!-- Back Button -->
<button class="back-button" onclick="goBack()">Back</button>

<!-- Link to Bootstrap JS and dependencies -->
<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

<script>
    function goBack() {
        window.location.href = 'Administrator'; // Replace with the URL of the page you want to navigate to
    }
</script>

</body>
</html>
