<?php
session_start();

error_reporting(E_ALL);
ini_set('display_errors', 1);

include 'Database.php';

if ($conn === null) {
    die("Database connection failed.");
}

$generate_key_message = "";
$manage_key_message = "";
$ban_devices_message = "";
$upload_message = "";
$delete_message = "";
$generate_failed_message = "";
$manage_key_failed_message = "";
$ban_devices_failed_message = "";
$upload_message_failed_message = "";
$delete_message_failed_message = "";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
   if (isset($_POST['generate_key_vip'])) {
    $key_name = trim($_POST['key_name']);
    $expiration_date = trim($_POST['expiration_date']);
    $usage_limit = intval($_POST['usage_limit']);
    $game_type = trim($_POST['game_type']); 
    if (!preg_match('/^[a-zA-Z0-9_]+$/', $key_name)) {
        $generate_failed_message = "Invalid key name, Only alphanumeric characters and underscores are allowed";
    }
    elseif ($usage_limit <= 0) {
        $generate_failed_message = "Usage limit must be greater than 0.";
    }
    elseif (!DateTime::createFromFormat('Y-m-d', $expiration_date)) {
        $generate_failed_message = "Invalid expiration date format. Use YYYY-MM-DD.";
    } else {
        $expiration_date = date('Y-m-d', strtotime($expiration_date));
        $key = $game_type . "-" . $key_name;
        $sql = "INSERT INTO api_keys (key_value, expiration_date, usage_limit) VALUES (?, ?, ?)";
        $stmt = $conn->prepare($sql);
        if ($stmt) {
            $stmt->bind_param("ssi", $key, $expiration_date, $usage_limit);

            if ($stmt->execute()) {
                $generate_key_message = "Key Created Successfully, Your Key: " . htmlspecialchars($key);
            } else {
                $generate_failed_message = "An error occurred while executing the statement: " . $stmt->error;
            }
            $stmt->close();
        } else {
            $generate_failed_message = "An error occurred while preparing the statement: " . $conn->error;
        }
    }
    
    } elseif (isset($_POST['generate_key_game'])) {
    $game_type = $_POST['game_type'];
    $expiration_date = $_POST['expiration_date'];
    $usage_limit = intval($_POST['usage_limit']);
    $number_of_keys = intval($_POST['number_of_keys']);
    if ($usage_limit <= 0) {
        $generate_failed_message = "Usage limit must be greater than 0.";
    } elseif (!DateTime::createFromFormat('Y-m-d', $expiration_date)) {
        $generate_failed_message = "Invalid expiration date.";
    } elseif ($number_of_keys <= 0) {
        $generate_failed_message = "Number of keys must be greater than 0.";
    } else {
        $expiration_date = date('Y-m-d', strtotime($expiration_date));
        $sql = "INSERT INTO api_keys (key_value, expiration_date, usage_limit) VALUES (?, ?, ?)";
        $stmt = $conn->prepare($sql);
        if ($stmt) {
            $conn->begin_transaction();
            try {
                for ($i = 0; $i < $number_of_keys; $i++) {
                    $key_suffix = strtoupper(bin2hex(random_bytes(5)));
                    $key = $game_type . '-' . $key_suffix;
                    $stmt->bind_param("ssi", $key, $expiration_date, $usage_limit);
                    $stmt->execute();
                }
                $conn->commit();
                $generate_key_message = "$number_of_keys Keys Created Successfully!";
            } catch (Exception $e) {
                $conn->rollback();
                $generate_failed_message = "An error occurred: " . $e->getMessage();
            }
            $stmt->close();
        } else {
            $generate_failed_message = "An error occurred while preparing the statement: " . $conn->error;
        }
    }
        
    } elseif (isset($_POST['delete_key']) && !empty($_POST['key_id'])) {
        $key_id = $_POST['key_id'];
        $conn->begin_transaction();
        try {
            $sql = "DELETE FROM device_ids WHERE api_key_id = ?";
            $stmt = $conn->prepare($sql);
            if ($stmt) {
                $stmt->bind_param("i", $key_id);
                $stmt->execute();
                $stmt->close();
            } else {
                $manage_key_failed_message = "An error occurred while preparing the statement: " . $conn->error;
            }

            $sql = "DELETE FROM api_keys WHERE id = ?";
            $stmt = $conn->prepare($sql);
            if ($stmt) {
                $stmt->bind_param("i", $key_id);
                if ($stmt->execute()) {
                    $conn->commit();
                    $manage_key_message = "Deleted Key Successful !";
                } else {
                    $manage_key_failed_message = "An error occurred while deleting the key: " . $stmt->error;
                }
                $stmt->close();
            } else {
                $manage_key_failed_message = "An error occurred while preparing the statement: " . $conn->error;
            }
        } catch (Exception $e) {
            $conn->rollback();
            $manage_key_message = $e->getMessage();
        }
    } elseif (isset($_POST['update_expiration']) && !empty($_POST['key_id'])) {
        $key_id = $_POST['key_id'];
        $new_expiration_date = $_POST['new_expiration_date'];
        $new_expiration_date = date('Y-m-d', strtotime($new_expiration_date));

        $sql = "UPDATE api_keys SET expiration_date = ? WHERE id = ?";
        $stmt = $conn->prepare($sql);

        if ($stmt) {
            $stmt->bind_param("si", $new_expiration_date, $key_id);
            if ($stmt->execute()) {
                $manage_key_message = "Updated New Time Limit For Successful Key !";
            } else {
                $manage_key_failed_message = "An error occurred while executing the statement: " . $stmt->error;
            }
            $stmt->close();
        } else {
            $manage_key_failed_message = "An error occurred while preparing the statement: " . $conn->error;
        }
    } elseif (isset($_POST['set_usage_limit']) && !empty($_POST['key_id'])) {
        $key_id = $_POST['key_id'];
        $new_usage_limit = intval($_POST['new_usage_limit']);

        if ($new_usage_limit <= 0) {
            $manage_key_failed_message = "Usage Limit Must Be Greater Than 0 ?";
        } else {
            $sql = "UPDATE api_keys SET usage_limit = ? WHERE id = ?";
            $stmt = $conn->prepare($sql);

            if ($stmt) {
                $stmt->bind_param("ii", $new_usage_limit, $key_id);
                if ($stmt->execute()) {
                    $manage_key_message = "Updated User Limit For Key Successfully !";
                } else {
                    $manage_key_failed_message = "An error occurred while executing the statement: " . $stmt->error;
                }
                $stmt->close();
            } else {
                $manage_key_failed_message = "An error occurred while preparing the statement: " . $conn->error;
            }
        }
    } elseif (isset($_POST['reset_user_count_specific']) && !empty($_POST['key_id'])) {
        $key_id = $_POST['key_id'];
        $conn->begin_transaction();
        try {
            $sql = "DELETE FROM device_ids WHERE api_key_id = ?";
            $stmt = $conn->prepare($sql);
            if ($stmt) {
                $stmt->bind_param("i", $key_id);
                $stmt->execute();
                $stmt->close();
            } else {
                $manage_key_failed_message = "An error occurred while preparing the statement: " . $conn->error;
            }

            $sql = "UPDATE api_keys SET current_usage = 0 WHERE id = ?";
            $stmt = $conn->prepare($sql);
            if ($stmt) {
                $stmt->bind_param("i", $key_id);
                if ($stmt->execute()) {
                    $conn->commit();
                    $manage_key_message = "Reset All Users Using 0 Successful !";
                } else {
                    $manage_key_failed_message = "An error occurred while updating the user count: " . $stmt->error;
                }
                $stmt->close();
            } else {
                $manage_key_failed_message = "An error occurred while preparing the statement: " . $conn->error;
            }
        } catch (Exception $e) {
            $conn->rollback();
            $manage_key_message = $e->getMessage();
        }
    } elseif (isset($_POST['ban_action']) && !empty($_POST['device_id']) && !empty($_POST['ban_reason'])) {
        $device_id = $_POST['device_id'];
        $ban_reason = $_POST['ban_reason'];

        $sql = "INSERT INTO banned_devices (device_id, ban_reason) VALUES (?, ?)
                ON DUPLICATE KEY UPDATE ban_reason = VALUES(ban_reason), banned_at = CURRENT_TIMESTAMP";
        $stmt = $conn->prepare($sql);

        if ($stmt) {
            $stmt->bind_param("ss", $device_id, $ban_reason);
            if ($stmt->execute()) {
                $ban_devices_message = "Banned Device ID: " . htmlspecialchars($device_id) . ", With Reason: " . htmlspecialchars($ban_reason) . "!";
            } else {
                $ban_devices_failed_message = "An error occurred while executing the statement: " . $stmt->error;
            }
            $stmt->close();
        } else {
            $ban_devices_failed_message = "An error occurred while preparing the statement: " . $conn->error;
        }
    } elseif (isset($_POST['unban_action']) && !empty($_POST['device_id'])) {
        $device_id = $_POST['device_id'];
        $conn->begin_transaction();
        try {
            $sql = "DELETE FROM banned_devices WHERE device_id = ?";
            $stmt = $conn->prepare($sql);
            if ($stmt) {
                $stmt->bind_param("s", $device_id);
                $stmt->execute();
                $stmt->close();
            } else {
                throw new Exception("An error occurred while preparing the statement: " . $conn->error);
            }
            $conn->commit();
            $ban_devices_message = "Unbanned Device ID: " . htmlspecialchars($device_id) . " Successfully !";
        } catch (Exception $e) {
            $conn->rollback();
            $ban_devices_message = $e->getMessage();
        }
    }

    if (isset($_POST['delete_data'])) {
        $conn->query("SET FOREIGN_KEY_CHECKS = 0");
        $tables = ["device_ids", "api_keys", "banned_devices"];
        $success = true;
        foreach ($tables as $table) {
            $sql = "TRUNCATE TABLE `$table`";
            if ($conn->query($sql) !== TRUE) {
                $success = false;
                $delete_message_failed_message = "Unable to delete data from table " . htmlspecialchars($table) . ": " . $conn->error;
                break;
            }
        }
        $conn->query("SET FOREIGN_KEY_CHECKS = 1");
        if ($success) {
            $delete_message = "All Data in Tables Deleted !";
        } else {
            $delete_message = $delete_message_failed_message;
        }
    }
}

if (isset($_POST['revoke_key_specific']) && !empty($_POST['key_id'])) {
    $key_id = $_POST['key_id'];
    $sql_check = "SELECT status FROM api_keys WHERE id = ?";
    $stmt = $conn->prepare($sql_check);
    if ($stmt) {
        $stmt->bind_param("i", $key_id);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($result->num_rows > 0) {
            $row = $result->fetch_assoc();
            if ($row['status'] == 'revoked') {
                $manage_key_failed_message = "This key has already been revoked.";
            } else {
                $sql_revoke = "UPDATE api_keys SET status = 'revoked' WHERE id = ?";
                $stmt_revoke = $conn->prepare($sql_revoke);
                if ($stmt_revoke) {
                    $stmt_revoke->bind_param("i", $key_id);
                    if ($stmt_revoke->execute()) {
                        $manage_key_message = "Success in Work Key Recall, Status : Revoked !";
                    } else {
                        $manage_key_failed_message = "Error revoking the key: " . $stmt_revoke->error;
                    }
                    $stmt_revoke->close();
                } else {
                    $manage_key_failed_message = "Error preparing the revoke statement: " . $conn->error;
                }
            }
        } else {
            $manage_key_failed_message = "Key does not exist.";
        }
        $stmt->close();
    } else {
        $manage_key_failed_message = "Error preparing the check statement: " . $conn->error;
    }
}

if (isset($_POST['unrevoke_key_specific']) && !empty($_POST['key_id'])) {
    $key_id = $_POST['key_id'];
    $conn->begin_transaction();
    try {
        $sql_check = "SELECT status FROM api_keys WHERE id = ?";
        $stmt = $conn->prepare($sql_check);
        if ($stmt) {
            $stmt->bind_param("i", $key_id);
            $stmt->execute();
            $result = $stmt->get_result();
            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                if ($row['status'] == 'revoked') {
                    $sql_update = "UPDATE api_keys SET status = 'active' WHERE id = ?";
                    $stmt_update = $conn->prepare($sql_update);
                    if ($stmt_update) {
                        $stmt_update->bind_param("i", $key_id);
                        if ($stmt_update->execute()) {
                            $conn->commit();
                            $manage_key_message = "Key Status Activation Success, Current Status: Active";
                        } else {
                            $manage_key_failed_message = "An error occurred while unrevoking the key: " . $stmt_update->error;
                        }
                        $stmt_update->close();
                    } else {
                        $manage_key_failed_message = "An error occurred while preparing the unrevoked statement: " . $conn->error;
                    }
                } else {
                    $manage_key_failed_message = "Key Is Already In Active State !";
                }
            } else {
                $manage_key_failed_message = "Key does not exist.";
            }
            $stmt->close();
        } else {
            $manage_key_failed_message = "An error occurred while preparing the check statement: " . $conn->error;
        }
    } catch (Exception $e) {
        $conn->rollback();
        $manage_key_message = $e->getMessage();
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['upload_file']) && isset($_POST['script_name'])) {
    $file = $_FILES['upload_file'];
    $scriptName = $_POST['script_name'];
    $uploadDir = 'Script/';
    $uploadFile = $uploadDir . $scriptName . '.lua';
    if (!is_dir($uploadDir) || !is_writable($uploadDir)) {
        $upload_message_failed = "Upload directory is not writable or does not exist.";
    } else {
        if ($file['error'] === UPLOAD_ERR_OK) {
            $fileType = pathinfo($file['name'], PATHINFO_EXTENSION);
            if ($fileType !== 'lua') {
                $upload_message_failed = "Only .lua Files Are Allowed!";
            } else {
                if (!move_uploaded_file($file['tmp_name'], $uploadFile)) {
                    $upload_message_failed = "File Upload Failed!";
                } else {
                    $prependContent = <<<'EOD'

EOD;
                    $combinedContent = $prependContent . file_get_contents($uploadFile);
                    file_put_contents($uploadFile, $combinedContent);

                    $upload_message = "File '$uploadFile' Uploaded Successfully!";
                }
            }
        } else {
            $upload_message_failed = "Error During File Upload !";
        }
    }
} else {
    $upload_message_failed = "No Files Were Uploaded Or Script Name Not Selected !";
}

$key_options = '';
$sql = "SELECT id, key_value FROM api_keys";
$result = $conn->query($sql);
while ($row = $result->fetch_assoc()) {
    $key_options .= "<option value=\"" . htmlspecialchars($row['id']) . "\">" . htmlspecialchars($row['key_value']) . "</option>";
}

$banned_device_options = '';
$sql = "SELECT DISTINCT device_id FROM banned_devices";
$result = $conn->query($sql);
while ($row = $result->fetch_assoc()) {
    $banned_device_options .= "<option value=\"" . htmlspecialchars($row['device_id']) . "\">" . htmlspecialchars($row['device_id']) . "</option>";
}

$select_device_options = '';
$sql = "SELECT DISTINCT device_id FROM device_ids";
$result = $conn->query($sql);
while ($row = $result->fetch_assoc()) {
    $select_device_options .= "<option value=\"" . htmlspecialchars($row['device_id']) . "\">" . htmlspecialchars($row['device_id']) . "</option>";
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Panel Admin Key System</title>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;500;700&display=swap">
    <link rel="icon" href="icons/logo-search.svg" type="image/png">
    
    <style>
        body {
    font-family: 'Roboto', sans-serif;
    background-color: #f4f7f9;
    color: #333;
    margin: 0;
    padding: 0;
    overflow-x: hidden;
    opacity: 0;
    transition: opacity 1s ease-in;
}
body.loaded {
    opacity: 1;
}
.container {
    width: 80%;
    margin: 5px auto;
    padding: 15px;
    background: white;
    box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
    border-radius: 8px;
}
#login-container {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: linear-gradient(to bottom, #4a90e2, #6cc3f1);
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 1000;
}
#login-form {
    background: #fff;
    border-radius: 12px;
    box-shadow: 0 6px 12px rgba(0, 0, 0, 0.15);
    padding: 30px;
    width: 360px;
    max-width: 90%;
    text-align: center;
    transition: transform 0.3s ease;
}
#login-form:hover {
    transform: translateY(-5px);
}
#login-form h2 {
    margin-bottom: 25px;
    font-size: 28px;
    color: #333;
    font-weight: 600;
}
#login-form input {
    width: calc(100% - 20px);
    padding: 12px;
    margin: 12px 0;
    border: 1px solid #dcdcdc;
    border-radius: 6px;
    font-size: 16px;
    transition: border-color 0.3s ease;
}
#login-form input:focus {
    border-color: #4a90e2;
    outline: none;
}
#login-form button {
    width: 100%;
    padding: 12px;
    border: none;
    border-radius: 6px;
    background-color: #4a90e2;
    color: white;
    font-size: 18px;
    cursor: pointer;
    transition: background-color 0.3s ease, transform 0.3s ease;
}
#login-form button:hover {
    background-color: #357abd;
    transform: scale(1.05);
}
#logout-btn {
    display: none;
    position: fixed;
    top: 20px;
    right: 20px;
    padding: 12px 24px;
    border: none;
    border-radius: 6px;
    background-color: #e94e77;
    color: white;
    font-size: 16px;
    cursor: pointer;
    transition: background-color 0.3s ease, transform 0.3s ease;
}
#logout-btn:hover {
    background-color: #d43f60;
    transform: scale(1.05);
}
#main-content {
    display: none;
    margin: 20px;
}
body.logged-in {
    overflow: auto;
}
.tabs {
    display: flex;
    justify-content: space-between;
    margin-bottom: 10px;
    padding-bottom: 15px;
    border-bottom: 2px solid #1e3a8a;
    gap: 8px;
}
.tab {
    flex: 1;
    padding: 10px;
    text-align: center;
    cursor: pointer;
    background-color: #f8f9fa;
    border: 1px solid #ced4da;
    margin-right: 5px;
    transition: background-color 0.3s, transform 0.2s, box-shadow 0.3s;
    box-shadow: 0 2px 6px rgba(0, 0, 0, 0.1);
}
.tab:hover {
    background-color: #e2e6ea;
}
.tab.active {
    background-color: #1e3a8a;
    color: white;
    transform: translateY(-4px);
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.15);
    border-color: #1e3a8a;
}
.tab-content {
    position: relative;
    max-height: 0;
    overflow: hidden;
    opacity: 0;
    transition: opacity 0.5s ease, max-height 0.5s ease;
    background-color: #f9fafb;
    border: 1px solid #e5e7eb;
    margin-top: 10px;
    border-radius: 6px;
}
.tab-content.active {
    max-height: 1000px;
    opacity: 1;
}
button::after {
    content: '';
    position: absolute;
    top: 50%;
    left: 50%;
    width: 300%;
    height: 300%;
    background: radial-gradient(circle, rgba(255,255,255,0.1) 20%, rgba(255,255,255,0) 80%);
    transition: transform 0.5s, opacity 0.5s;
    transform: translate(-50%, -50%) scale(0);
    opacity: 0;
    border-radius: 50%;
}
button:active::after {
    transform: translate(-50%, -50%) scale(1);
    opacity: 1;
}
input[type="text"], input[type="date"], input[type="number"], textarea, select {
    margin-bottom: 15px;
    padding: 12px;
    border: 1px solid #ccc;
    border-radius: 8px;
    width: calc(100% - 24px);
    box-sizing: border-box;
    font-size: 16px;
    transition: border-color 0.3s ease;
}
input[type="text"]:focus, input[type="date"]:focus, input[type="number"]:focus, textarea:focus, select:focus {
    border-color: #28a745;
    box-shadow: 0 0 5px rgba(40, 167, 69, 0.3);
}
.fade-out {
    opacity: 0;
    transition: opacity 0.5s ease-out;
}
.scrollable-content {
    max-height: 700px;
    width: 99%;
    overflow-y: auto;
    padding: 10px;
    border: 1px solid #ddd;
}
.upload-container {
    background-color: #fff;
    padding: 30px 20px;
    border-radius: 12px;
    box-shadow: 0 8px 16px rgba(0, 0, 0, 0.1);
    width: 320px;
    text-align: center;
    margin: 15px;
    transition: transform 0.2s, box-shadow 0.2s;
}
.upload-container:hover {
    transform: translateY(-5px);
    box-shadow: 0 12px 24px rgba(0, 0, 0, 0.15);
}
.notification {
    display: none;
    position: relative;
    padding: 16px 24px;
    border-radius: 8px;
    margin-bottom: 24px;
    border-left: 6px solid;
    display: flex;
    align-items: center;
    box-shadow: 0 6px 12px rgba(0, 0, 0, 0.1);
    transition: background-color 0.3s ease, border-color 0.3s ease, opacity 0.3s ease;
    font-family: 'Arial', sans-serif;
    font-size: 16px;
    line-height: 1.5;
    max-width: 600px;
}
.notification.success {
    background-color: #e6f4ea;
    color: #155724;
    border-color: #28a745;
}
.notification.error {
    background-color: #fef0f1;
    color: #721c24;
    border-color: #dc3545;
}
.notification.info {
    background-color: #e7f0f7;
    color: #004085;
    border-color: #17a2b8;
}
.notification.warning {
    background-color: #fff8e5;
    color: #856404;
    border-color: #ffc107;
}
.notification .icon {
    width: 24px;
    height: 24px;
    margin-right: 15px;
    flex-shrink: 0;
}
.notification.success .icon {
    background: url('icons/check2.png') no-repeat center center;
    background-size: contain;
}
.notification.error .icon {
    background: url('icons/error2.png') no-repeat center center;
    background-size: contain;
}
.notification.info .icon {
    background: url('icons/info2.png') no-repeat center center;
    background-size: contain;
}
.notification.warning .icon {
    background: url('icons/warning2.png') no-repeat center center;
    background-size: contain;
}
.notification:hover {
    box-shadow: 0 8px 16px rgba(0, 0, 0, 0.15);
    opacity: 0.95;
}
h1 {
    margin-top: 0;
    color: #333;
    font-size: 32px;
    font-weight: 700;
}
p {
    color: #666;
    font-size: 18px;
    line-height: 1.6;
}
button {
    font-weight: 700;
}
        button {
            background-color: #1e3a8a;
            color: white;
            border: none;
            cursor: pointer;
            padding: 12px;
            border-radius: 8px;
            font-size: 16px;
            transition: background-color 0.3s, transform 0.2s, box-shadow 0.3s;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
        button:hover {
            background-color: #1e3a8a;
            transform: translateY(-2px);
            box-shadow: 0 6px 10px rgba(0, 0, 0, 0.2);
        }
        button:active {
            background-color: #1e3a8a;
            transform: translateY(0);
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
        }
        #file-input {
         display: none;
        }
    </style>
</head>
<body>
<div id="login-container">
    <form id="login-form">
        <h2>Key System Management</h2>
        <input type="password" id="password" placeholder="Enter Password" required>
        <button type="submit">Submit</button>
    </form>
</div>
    <div class="container">
        <h1><i class="fas fa-key"></i> Key System Management</h1>
        <div class="tabs">
            <div class="tab <?php echo $current_tab === 'generate_key' ? 'active' : ''; ?>" data-tab="generate_key">Generate Key</div>
            <div class="tab <?php echo $current_tab === 'manage_key' ? 'active' : ''; ?>" data-tab="manage_key">Edit Key</div> 
            <div class="tab <?php echo $current_tab === 'ban_devices' ? 'active' : ''; ?>" data-tab="ban_devices">Ban Action</div>
                    <div class="tab <?php echo $current_tab === 'new_tab' ? 'active' : ''; ?>" data-tab="new_tab">Setting</div>
                </div>        
                
         <div class="tab-content <?php echo $current_tab === 'generate_key' ? 'active' : ''; ?>" id="generate_key">
                 <div class="scrollable-content">
            <?php if ($generate_key_message): ?>
    <div class="notification <?php echo strpos($generate_key_message, 'Error') === false ? 'success' : 'error'; ?>">
        <div class="icon"></div>
        <p><?php echo htmlspecialchars($generate_key_message); ?></p>
    </div>
<?php endif; ?>

<?php if ($generate_failed_message): ?>
    <div class="notification <?php echo strpos($generate_failed_message, 'Error') === true ? 'success' : 'error'; ?>">
        <div class="icon"></div>
        <p><?php echo htmlspecialchars($generate_failed_message); ?></p>
    </div>
<?php endif; ?>

            <form method="post">
    <h3><i class="fas fa-gem"></i> Generate Paid Key</h3>
    <label for="game_type">Game Type :</label> 
    <br><br>
    <select id="game_type" name="game_type" required>
        <option value="" disabled selected> Select Game</option>
        <option value="VIPSCRIPT1">Game 1</option>
        <option value="VIPSCRIPT2">Game 2</option>
        <option value="VIPSCRIPT3">Game 3</option>
    </select>
        <label for="key_name">Name Key :</label>
    <br>
    <input type="text" name="key_name" placeholder="Enter Name" required>
    <label for="expiration_date">Expiration Date :</label>
    <br>
    <input type="date" name="expiration_date" required>
    <label for="usage_limit">Usage Limit :</label>
    <br>
    <input type="number" name="usage_limit" placeholder="Enter Number" min="1" required>
    <button type="submit" name="generate_key_vip">Submit</button>
</form> <br> <br>
            
<form method="post">
    <h3><i class="fa-brands fa-keybase"></i> Generate Free Key</h3>
    <label for="game_type">Game Type :</label>
    <br><br>
    <select id="game_type" name="game_type" required>
        <option value="" disabled selected> Select Game</option>
        <option value="SCRIPT1">Game 1</option>
        <option value="SCRIPT2">Game 2</option>
        <option value="SCRIPT3">Game 3</option>
    </select>
    <label for="expiration_date">Expiration Date :</label>
    <br>
    <input type="date" name="expiration_date" required>
    <label for="usage_limit">Usage Limit :</label>
    <br>
    <input type="number" name="usage_limit" placeholder="Enter Number" min="1" required>
    <label for="number_of_keys">Number Of Keys :</label>
    <br>
    <input type="number" name="number_of_keys" placeholder="Enter Number" min="1" required>
    <button type="submit" name="generate_key_game">Submit</button>
</form>            
        </div>
     </div>
     
    <div class="tab-content <?php echo $current_tab === 'manage_key' ? 'active' : ''; ?>" id="manage_key">
        <div class="scrollable-content">
            <?php if ($manage_key_message): ?>
                <div class="notification <?php echo strpos($manage_key_message, 'Error') === false ? 'success' : 'error'; ?>">
                    <div class="icon"></div>
                    <p><?php echo htmlspecialchars($manage_key_message); ?></p>
                </div>
            <?php endif; ?>
           
            <?php if ($manage_key_failed_message): ?>
                <div class="notification <?php echo strpos($manage_key_failed_message, 'Error') === true ? 'success' : 'error'; ?>">
                    <div class="icon"></div>
                    <p><?php echo htmlspecialchars($manage_key_failed_message); ?></p>
                </div>
            <?php endif; ?>
            <form method="post">
                <h3><i class="fas fa-trash-can"></i> Delete Key </h3>
                <p>Function used to delete key, please select below</p>
                <select name="key_id" required>       
                    <option value="" disabled selected>Select Key</option>
                    <?php echo $key_options; ?>
                </select>
                <button type="submit" name="delete_key">Submit</button> <br>
            </form> <br>
            
            <form method="post">
                <h3><i class="fas fa-clock"></i> Update Expiration Date</h3>
                <p>Function used to update key expiration time, please select key and your date option</p>
                <select name="key_id" required>
                    <option value="" disabled selected>Select Key</option>
                    <?php echo $key_options; ?>
                </select>
                <input type="date" name="new_expiration_date" required>
                <button type="submit" name="update_expiration">Submit </button><br>
            </form> <br>
            <form method="post">
                <h3><i class="fas fa-users"></i></i> Set Usage Limit</h3>
                <p>Function to set limit on number of devices that can access key, please select key and number to set</p>
                <select name="key_id" required>
                    <option value="" disabled selected>Select Key</option>
                    <?php echo $key_options; ?>
                </select>
                <input type="number" name="new_usage_limit" placeholder="New Usage Limit" required>
                <button type="submit" name="set_usage_limit">Submit</button><br>
            </form> <br>
            <form method="post">
                <h3><i class="fas fa-user-minus"></i> Reset Current Usage</h3>
                <p>Function used to reset the number of current users for the initial key to 0</p>
                <select name="key_id" required>
                    <option value="" disabled selected>Select Key</option>
                    <?php echo $key_options; ?>
                </select>
                <button type="submit" name="reset_user_count_specific">Submit</button><br>
            </form> <br>
                        <form method="post">
                <h3><i class="fas fa-lock"></i> Revoked Key</h3>
                <p>Function used to temporarily disable active keys, consider when using</p>
                <select name="key_id" required>
                    <option value="" disabled selected>Select Key</option>
                    <?php echo $key_options; ?>
                </select>
                <button type="submit" name="revoke_key_specific">Submit</button><br>
            </form>
                                    <form method="post">
                <h3><i class="fas fa-unlock"></i> Activate Key</h3>
                <p>Function used to activate the key status back to work !</p>
                <select name="key_id" required>
                    <option value="" disabled selected>Select Key</option>
                    <?php echo $key_options; ?>
                </select>
                <button type="submit" name="unrevoke_key_specific">Submit</button><br>
            </form>
        </div>
    </div>

        <div class="tab-content <?php echo $current_tab === 'ban_devices' ? 'active' : ''; ?>" id="ban_devices">
                <div class="scrollable-content">
    <?php if ($ban_devices_message): ?>
        <div class="notification <?php echo strpos($ban_devices_message, 'Error') === false ? 'success' : 'error'; ?>">
            <div class="icon"></div>
            <p><?php echo htmlspecialchars($ban_devices_message); ?></p>
        </div>
    <?php endif; ?>
                <?php if ($ban_devices_failed_message): ?>
    <div class="notification <?php echo strpos($ban_devices_failed_message, 'Error') === true ? 'success' : 'error'; ?>">
        <div class="icon"></div>
        <p><?php echo htmlspecialchars($ban_devices_failed_message); ?></p>
    </div>
<?php endif; ?>
    <form method="post">
                    <h3><i class="fas fa-user-pen"></i> Banned User</h3>
                    <p>Function to ban devices from accessing, ban anyone if you want</p>
        <select name="device_id" required>
            <option value="" disabled selected>Select ID Device</option>
            <?php echo $select_device_options; ?>
        </select>
        <input type="text" name="ban_reason" placeholder="Reason for Ban" required>
        <button type="submit" name="ban_action">Ban Device</button>
    </form> <br>
    <form method="post">
                    <h3><i class="fas fa-user-slash"></i> UnBanned User</h3>
                    <p>Function to unban devices from accessing, unban anyone if you want</p>
        <select name="device_id" required>
            <option value="" disabled selected>Select ID Device</option>
            <?php echo $banned_device_options; ?>
        </select>
        <button type="submit" name="unban_action">Unban Device</button>
    </form>
</div>       
</div>

<div class="tab-content <?php echo $current_tab === 'new_tab' ? 'active' : ''; ?>" id="new_tab">
        <div class="scrollable-content">
 <?php if ($upload_message): ?>
    <div class="notification <?php echo strpos($upload_message, 'Error') === false ? 'success' : 'error'; ?>">
        <div class="icon"></div>
        <p><?php echo htmlspecialchars($upload_message); ?></p>
    </div>
<?php endif; ?>

<?php if ($delete_message): ?>
    <div class="notification <?php echo strpos($delete_message, 'Error') === false ? 'success' : 'error'; ?>">
        <div class="icon"></div>
        <p><?php echo htmlspecialchars($delete_message); ?></p>
    </div>
<?php endif; ?>
    <?php if ($upload_message_failed_message): ?>
    <div class="notification <?php echo strpos($upload_message_failed_message, 'Error') === true ? 'success' : 'error'; ?>">
        <div class="icon"></div>
        <p><?php echo htmlspecialchars($upload_message_failed_message); ?></p>
    </div>
<?php endif; ?>

    <?php if ($delete_message_failed_message): ?>
    <div class="notification <?php echo strpos($delete_message_failed_message, 'Error') === true ? 'success' : 'error'; ?>">
        <div class="icon"></div>
        <p><?php echo htmlspecialchars($delete_message_failed_message); ?></p>
    </div>
<?php endif; ?>

               <h3><i class="fas fa-circle-info"></i> Check Information Table</h3>
                   <p>Function used to check all information from database click to view</p>
        <button type="submit" onclick="submitForm2()">Submit</button> <br> <br>
    
              <form method="POST" action="">
                    <h3><i class="fas fa-database"></i> Format Data All Table</h3>
                        <p>Please consider carefully before doing this, because it will delete all user data</p>
        <button type="submit" name="delete_data" onclick="return confirm('Are you sure you want to delete all data?');">Submit</button> 
    </form> <br>
     
<form action="" method="post" enctype="multipart/form-data" id="upload-form">
    <h3><i class="fas fa-cloud-arrow-up"></i> Upload Lua Script</h3>
           <p>Upload Your Lua Script Here, Will Help Protect Your Script !</p>
    <select name="script_name" required>
        <option value="" disabled selected>Select Script</option>
        <option value="FreeScript1">Free Script 1</option>
        <option value="FreeScript2">Free Script 2</option>
        <option value="FreeScript3">Free Script 3</option>
        <option value="VIPScript1">VIP Script 1</option>
        <option value="VIPScript2">VIP Script 2</option>
        <option value="VIPScript3">VIP Script 3</option>
    </select>
    
    <!-- File Input Hidden by Default -->
    <input type="file" id="file-input" name="upload_file" accept=".lua" required style="display: none;" onchange="document.getElementById('upload-form').submit();">
    
    <!-- Upload Button -->
    <button type="button" onclick="document.getElementById('file-input').click();">Upload</button>
</form>


</div>
</div>

    <div class="footer">
        <p>© Powered By Xnxx</p>
    </div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const password = '1407';
    const loginForm = document.getElementById('login-form');
    const logoutForm = document.getElementById('logout-form');
    const loginContainer = document.getElementById('login-container');
    const mainContent = document.getElementById('main-content');
    const body = document.body;
    let timeoutId;

    function resetTimeout() {
        clearTimeout(timeoutId);
        timeoutId = setTimeout(function() {
            localStorage.removeItem('loggedIn');
            localStorage.removeItem('lastInteraction');
            loginContainer.style.display = 'flex';
            mainContent.style.display = 'none';
            body.classList.remove('logged-in');
        }, 30 * 60 * 1000);
    }

    if (localStorage.getItem('loggedIn') === 'true') {
        const lastInteraction = localStorage.getItem('lastInteraction');
        const currentTime = new Date().getTime();

        if (currentTime - lastInteraction > 30 * 60 * 1000) {
            localStorage.removeItem('loggedIn');
            localStorage.removeItem('lastInteraction');
        } else {
            loginContainer.style.display = 'none';
            mainContent.style.display = 'block';
            body.classList.add('logged-in');
            resetTimeout();
        }
    }

    function updateLastInteraction() {
        localStorage.setItem('lastInteraction', new Date().getTime());
    }

    loginForm.addEventListener('submit', function(event) {
        event.preventDefault();
        const inputPassword = document.getElementById('password').value;

        if (inputPassword === password) {
            setTimeout(function() {
                localStorage.setItem('loggedIn', 'true');
                updateLastInteraction();
                loginContainer.style.display = 'none';
                mainContent.style.display = 'block';
                body.classList.add('logged-in');
                resetTimeout();
            }, 1000);
        } else {
            alert('Incorrect password. Please try again.');
        }
    });

    logoutForm.addEventListener('submit', function(event) {
        event.preventDefault();
        localStorage.removeItem('loggedIn');
        localStorage.removeItem('lastInteraction');
        loginContainer.style.display = 'flex';
        mainContent.style.display = 'none';
        body.classList.remove('logged-in');
        clearTimeout(timeoutId);
    });

    document.addEventListener('visibilitychange', function() {
        if (document.hidden) {
            clearTimeout(timeoutId);
        } else {
            resetTimeout();
            updateLastInteraction();
        }
    });

    window.addEventListener('load', function() {
        if (localStorage.getItem('loggedIn') === 'true') {
            updateLastInteraction();
            resetTimeout();
        }
    });

    document.addEventListener('mousemove', updateLastInteraction);
    document.addEventListener('keydown', updateLastInteraction);
});

document.addEventListener('DOMContentLoaded', function() {
    document.body.classList.add('loaded');

    const tabs = document.querySelectorAll('.tab');
    const tabContents = document.querySelectorAll('.tab-content');

    const activeTab = localStorage.getItem('activeTab') || tabs[0].getAttribute('data-tab');
    
    function showTab(tabId) {
        document.body.classList.add('fade-out');

        setTimeout(() => {
            tabs.forEach(tab => tab.classList.remove('active'));
            tabContents.forEach(content => {
                if (content.id === tabId) {
                    content.classList.add('active');
                } else {
                    content.classList.remove('active');
                }
            });

            const activeTabElement = document.querySelector(`.tab[data-tab="${tabId}"]`);
            if (activeTabElement) {
                activeTabElement.classList.add('active');
            }

            document.body.classList.remove('fade-out');
        }, 300);
    }

    showTab(activeTab);

    tabs.forEach(tab => {
        tab.addEventListener('click', function(event) {
            const tabId = tab.getAttribute('data-tab');
            localStorage.setItem('activeTab', tabId);

            if (tabId === 'fdos') {
                event.preventDefault();
                window.location.reload();
            } else {
                showTab(tabId);
            }
        });
    });
    
    function hideNotifications() {
        const notifications = document.querySelectorAll('.notification');
        notifications.forEach(notification => {
            notification.style.display = 'none';
        });
    }

    tabs.forEach(tab => {
        tab.addEventListener('click', hideNotifications);
    });
});

document.querySelectorAll('button').forEach(button => {
    button.addEventListener('mousedown', () => {
        button.classList.add('clicked');
        setTimeout(() => button.classList.remove('clicked'), 500);
    });
});

function UPLOAD() {
            document.getElementById('upload-form').submit();
        }

function submitForm2() {
    window.location.href = 'Table'; 
}
</script>
</body>
</html>
