<?php

error_reporting(E_ALL);
ini_set('display_errors', 1);

include 'Database.php';
include 'Key.php';

if ($conn === null) {
    die("Database connection failed.");
}

$FreeScript1 = 'Script/FreeScript1.lua'; 
$FreeScript2 = 'Script/FreeScript2.lua'; 
$FreeScript3 = 'Script/FreeScript3.lua'; 
$VIPScript1 = 'Script/VIPScript1.lua'; 
$VIPScript2 = 'Script/VIPScript2.lua'; 
$VIPScript3 = 'Script/VIPScript3.lua'; 
$usedTokensLogFile = 'Token.txt';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
      header('HTTP/1.0 403 Forbidden');
      echo "Access Denied";
      exit();
}

function xorEncrypt($data, $key) {
    $out = '';
    for ($i = 0; $i < strlen($data); $i++) {
        $out .= $data[$i] ^ $key[$i % strlen($key)];
    }
    return $out;
}

function exitAlert($msg) {
    include 'Key.php';
    $message = "gg.setVisible(true) gg.alert('" . addslashes($msg) . "', '')";
    $encryptedMessage = xorEncrypt($message, $key);
    exit($encryptedMessage);
}


function logSuccessfulLogin($key_value, $scriptToRun, $device_id) {
    $logFile = 'Log.txt'; 
    $ip_address = $_SERVER['REMOTE_ADDR'];
    $user_agent = $_SERVER['HTTP_USER_AGENT'] ?? '';
    
    $api_key = "188730-280004-368s18-883e2u";
    $url = "https://proxycheck.io/v2/$ip_address?key=$api_key&vpn=1&asn=1";
    
    $response = file_get_contents($url);
    $data = json_decode($response, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        exitAlert("┇ Failed To Parse API Response, Please Try Again Later !");
    }

    $country = isset($data[$ip_address]['country']) ? $data[$ip_address]['country'] : 'Unknown';
    $region = isset($data[$ip_address]['region']) ? $data[$ip_address]['region'] : 'Unknown';
    $request_method = $_SERVER['REQUEST_METHOD'];
    $logEntry = sprintf(
        "────────────────────────\n".
        "Timestamp : %s\n".
        "Device ID : %s\n".
        "IP : %s | Country : %s | Region : %s\n".
        "User-Agent : %s\n".
        "Script : %s\n".
        "Method : %s\n".
        "────────────────────────\n\n",
        date('Y-m-d H:i:s'),
        $device_id,
        $ip_address,
        $country,
        $region,
        $user_agent,
        $scriptToRun,
        $request_method
    );
    $existingLogs = file_exists($logFile) ? file_get_contents($logFile) : '';
    $existingLogs = preg_replace("/^────────────────────────\nTimestamp : [^\n]*\nDevice ID : " . preg_quote($device_id, '/') . "[^\n]*\n.*?────────────────────────\n\n/sm", '', $existingLogs);
    $updatedLogs = $existingLogs . $logEntry;
    file_put_contents($logFile, $updatedLogs);
}

$api_key = "188730-280004-368s18-883e2u";
$ip_to_check = $_SERVER['REMOTE_ADDR'];

$url = "https://proxycheck.io/v2/$ip_to_check?key=$api_key&vpn=1&asn=1";
$response = file_get_contents($url);
$data = json_decode($response, true);

if (json_last_error() !== JSON_ERROR_NONE) {
    exitAlert("┇ Failed To Parse API Response, Please Try Again Later !");
}

$vpn = isset($data[$ip_to_check]['proxy']) && $data[$ip_to_check]['proxy'] === "yes";

if ($vpn) {
    exitAlert("┇ VPN Or Proxy Detected, Please Disable And Try Again !");
}

$conn->begin_transaction();

try {
    function isSimilarToken($newToken, $usedTokens, $threshold = 20) {
        foreach ($usedTokens as $usedToken) {
            if (levenshtein($newToken, $usedToken) <= $threshold) {
                return true;
            }
        }
        return false;
    }

    $data_input = $_POST['Data'] ?? '';
    
    if (empty($data_input)) {
        exitAlert("┇ No Data Received");
    }

    function xorDecrypt($data, $key) {
        $result = '';
        for ($i = 0; $i < strlen($data); $i++) {
            $result .= $data[$i] ^ $key[$i % strlen($key)];
        }
        return $result;
    }

    $decodedData = xorDecrypt($data_input, $key);
    if ($decodedData === false) {
        exitAlert("┇ Data Decoding Failed");
    }

    list($key_input, $token_input) = explode("|", $decodedData);

    $token_input = trim($token_input);
    error_log("Received Token : $token_input");

    if (strlen($token_input) !== 32) {
        exit();
    }

    if (empty($token_input)) {
        exit();
    }

    if (file_exists($usedTokensLogFile)) {
        $usedTokens = file($usedTokensLogFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        
        if (in_array($token_input, $usedTokens)) {
            exit();
        }
        
        if (isSimilarToken($token_input, $usedTokens)) {
            exit();
        }
    }

    file_put_contents($usedTokensLogFile, $token_input . PHP_EOL, FILE_APPEND);

    $stmt_key = $conn->prepare("SELECT id, usage_limit, expiration_date, current_usage, status FROM api_keys WHERE key_value = ?");
    if (!$stmt_key) throw new Exception("Error preparing statement: " . $conn->error);

    $stmt_key->bind_param("s", $key_input);
    $stmt_key->execute();
    $result_key = $stmt_key->get_result();

    if ($result_key->num_rows === 1) {
        $key_data = $result_key->fetch_assoc();
        $key_id = $key_data['id'];
        $expiration_date = $key_data['expiration_date'];
        $usage_limit = $key_data['usage_limit'];
        $current_usage = $key_data['current_usage'];
        $status = $key_data['status'];

        if ($status === 'revoked') {
            exitAlert("┇ Current Key Has Been Revoked, So It Cannot Be Accessed Using This Key, Please Contact Publisher For Resolution !");
        }

        if ($status === 'expired' && new DateTime() < new DateTime($expiration_date)) {
            $stmt_update_status = $conn->prepare("UPDATE api_keys SET status = 'active' WHERE id = ?");
            if (!$stmt_update_status) throw new Exception("Error preparing status update statement: " . $conn->error);

            $stmt_update_status->bind_param("i", $key_id);
            $stmt_update_status->execute();
            $stmt_update_status->close();

            $status = 'active';
        }

        if ($status === 'active') {
            if (new DateTime() <= new DateTime($expiration_date)) {
                $hash = hash('sha256', $_SERVER['HTTP_USER_AGENT'] ?? '', true);
                $device_id = base_convert(bin2hex($hash), 16, 10); 
                $device_id = substr($device_id, 0, 24);

                $stmt_ban_check = $conn->prepare("SELECT * FROM banned_devices WHERE device_id = ?");
                if (!$stmt_ban_check) throw new Exception("Error preparing statement: " . $conn->error);

                $stmt_ban_check->bind_param("s", $device_id);
                $stmt_ban_check->execute();
                $result_ban = $stmt_ban_check->get_result();

                if ($result_ban->num_rows > 0) {
                    exitAlert("┇ Your Device ID Has Been Banned !");
                } else {
                    $stmt_device_check = $conn->prepare("SELECT number_key_id FROM device_ids WHERE device_id = ? AND api_key_id = ?");
                    if (!$stmt_device_check) throw new Exception("Error preparing statement: " . $conn->error);

                    $stmt_device_check->bind_param("si", $device_id, $key_id);
                    $stmt_device_check->execute();
                    $result_device_check = $stmt_device_check->get_result();

                    if ($result_device_check->num_rows > 0) {
                        $device_data = $result_device_check->fetch_assoc();
                        $number_key_id = $device_data['number_key_id'];

                        if ($number_key_id > $usage_limit) {
                            exitAlert("┇ This Key Has Reached Maximum Users !");
                        }
                    } else {
                        $stmt_number_key_id = $conn->prepare("SELECT IFNULL(MAX(number_key_id), 0) + 1 AS next_key_id FROM device_ids WHERE api_key_id = ?");
                        if (!$stmt_number_key_id) throw new Exception("Error preparing statement: " . $conn->error);

                        $stmt_number_key_id->bind_param("i", $key_id);
                        $stmt_number_key_id->execute();
                        $result_number_key_id = $stmt_number_key_id->get_result();
                        $number_key_id = $result_number_key_id->fetch_assoc()['next_key_id'];

                        if ($number_key_id > $usage_limit) {
                            exitAlert("┇ This Key Has Reached Maximum Users !");
                        }

                        $stmt_insert = $conn->prepare("INSERT INTO device_ids (device_id, api_key_id, number_key_id) VALUES (?, ?, ?)");
                        if (!$stmt_insert) throw new Exception("Error preparing statement: " . $conn->error);

                        $stmt_insert->bind_param("sii", $device_id, $key_id, $number_key_id);
                        $stmt_insert->execute();
                        $stmt_insert->close();
                    }

                    if ($number_key_id > $current_usage) {
                        $stmt_update_usage = $conn->prepare("UPDATE api_keys SET current_usage = ? WHERE id = ?");
                        if (!$stmt_update_usage) throw new Exception("Error preparing statement: " . $conn->error);

                        $stmt_update_usage->bind_param("ii", $number_key_id, $key_id);
                        $stmt_update_usage->execute();
                        $stmt_update_usage->close();
                    }

                    $stmt_remove_null_keys = $conn->prepare("DELETE FROM device_ids WHERE api_key_id IS NULL");
                    if (!$stmt_remove_null_keys) throw new Exception("Error preparing statement: " . $conn->error);

                    $stmt_remove_null_keys->execute();
                    $stmt_remove_null_keys->close();

                    $conn->commit();

                    if (strpos($key_input, 'SCRIPT1-') === 0) {
                        $scriptToRun = $FreeScript1;
                    } elseif (strpos($key_input, 'SCRIPT2-') === 0) {
                        $scriptToRun = $FreeScript2;
                    } elseif (strpos($key_input, 'SCRIPT3-') === 0) {
                        $scriptToRun = $FreeScript3;
                    } elseif (strpos($key_input, 'VIPSCRIPT1-') === 0) {
                        $scriptToRun = $VIPScript1;
                    } elseif (strpos($key_input, 'VIPSCRIPT2-') === 0) {
                        $scriptToRun = $VIPScript2;
                    } elseif (strpos($key_input, 'VIPSCRIPT3-') === 0) {
                        $scriptToRun = $VIPScript3;
                    } else {
                        exitAlert("┇ Invalid Key Format");
                    }

                    if (file_exists($scriptToRun)) {
    header('Content-Type: text/plain');
    header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
    header('Expires: 0');
    header('Pragma: no-cache');
    logSuccessfulLogin($key_id, $scriptToRun, $device_id);
    $scriptContent = file_get_contents($scriptToRun);
    $EncryptScript = xorEncrypt($scriptContent, $key);
    exit($EncryptScript);
} else {
    exitAlert("┇ Script Not Found In Server");
}
                }
            } else {
                $stmt_update_status = $conn->prepare("UPDATE api_keys SET status = 'expired' WHERE id = ?");
                if (!$stmt_update_status) throw new Exception("Error preparing status update statement: " . $conn->error);

                $stmt_update_status->bind_param("i", $key_id);
                $stmt_update_status->execute();

                if ($stmt_update_status->affected_rows === 0) {
                    error_log("Failed to update status for key ID: " . $key_id);
                }

                $stmt_update_status->close();

                $conn->commit();

                exitAlert("┇ Key Expired, Please Contact Publisher");
            }
        } else {
            exitAlert("┇ Invalid Key Status");
        }
    } else {
        exitAlert("┇ Wrong Key, Please Contact Publisher");
    }

    $stmt_key->close();
    $stmt_ban_check->close();
    $stmt_device_check->close();
    $stmt_number_key_id->close();
} catch (Exception $e) {
    $conn->rollback();
    exitAlert("┇ An Error Occurred: " . $e->getMessage());
}

$conn->close();
?>
