<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

include 'Database.php';

if ($conn === null) {
    die("Database connection failed.");
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('HTTP/1.0 403 Forbidden');
    echo "Access denied";
    exit();
}

include 'Key.php';

$data_input = $_POST['Panel'] ?? '';

function xorDecrypt($data, $key) {
    $result = '';
    for ($i = 0; $i < strlen($data); $i++) {
        $result .= $data[$i] ^ $key[$i % strlen($key)];
    }
    return $result;
}

function xorEncrypt($data, $key) {
    $result = '';
    for ($i = 0; $i < strlen($data); $i++) {
        $result .= $data[$i] ^ $key[$i % strlen($key)];
    }
    return $result;
}

$decodedData = xorDecrypt($data_input, $key);
if ($decodedData === false) {
    exit("┇ Data Decoding Failed");
}

$key_input = $decodedData;

if ($key_input) {
    $sql_key = "SELECT id, usage_limit, expiration_date, current_usage, key_value FROM api_keys WHERE key_value = ?";
    $stmt_key = $conn->prepare($sql_key);
    if (!$stmt_key) {
        die("Error preparing database statement: " . $conn->error);
    }

    $stmt_key->bind_param("s", $key_input);
    $stmt_key->execute();
    $result_key = $stmt_key->get_result();

    if ($result_key->num_rows === 1) {
        $key_data = $result_key->fetch_assoc();
        $key_id = $key_data['id'];
        $key_value = $key_data['key_value'];
        $expiration_date = $key_data['expiration_date'];
        $usage_limit = $key_data['usage_limit'];
        $current_usage = $key_data['current_usage'];
        $sql_device_info = "SELECT device_id FROM device_ids WHERE api_key_id = ?";
        $stmt_device_info = $conn->prepare($sql_device_info);
        if (!$stmt_device_info) {
            die("Error preparing database statement: " . $conn->error);
        }

        $stmt_device_info->bind_param("i", $key_id);
        $stmt_device_info->execute();
        $result_device_info = $stmt_device_info->get_result();

        $info = ''; 

        if ($result_device_info->num_rows > 0) {
            $device_row = $result_device_info->fetch_assoc();
            $device_id = $device_row['device_id'];
            $sql_banned = "SELECT ban_reason, banned_at FROM banned_devices WHERE device_id = ?";
            $stmt_banned = $conn->prepare($sql_banned);
            if (!$stmt_banned) {
                die("Error preparing database statement: " . $conn->error);
            }

            $stmt_banned->bind_param("s", $device_id);
            $stmt_banned->execute();
            $result_banned = $stmt_banned->get_result();

            if ($result_banned->num_rows > 0) {
                $banned_data = $result_banned->fetch_assoc();
                $info .= "┇ Detected Your Device Has Been Banned !\n\n";
                $info .= " ID : $device_id\n\n";
                $info .= " You Have Been Officially Banned From Our Scenario, If You Have Any Questions Please Contact The Publisher !\n";
            } else {
                if (strtotime($expiration_date) < time()) {
                    $info .= "┇ Detected The Key Has Expired\n\n";
                    $info .= " Expiration Date : " . date('d - m - Y', strtotime($expiration_date)) . "\n\n";
                    $info .= " Current Date : " . date('d - m - Y') . "\n";
                } else {
                    $prefix = '';
                    if (strpos($key_input, 'SF2_FREE-') === 0) {
                        $prefix = 'Shadow Fight 2';
                    } elseif (strpos($key_input, 'SF3_FREE-') === 0) {
                        $prefix = 'Shadow Fight 3';
                    } elseif (strpos($key_input, 'SFA_FREE-') === 0) {
                        $prefix = 'Shadow Fight Arena';
                    } elseif (strpos($key_input, 'SF2_VIP-') === 0) {
                        $prefix = 'Shadow Fight 2';
                    } elseif (strpos($key_input, 'SF3_VIP-') === 0) {
                        $prefix = 'Shadow Fight 3';
                    } elseif (strpos($key_input, 'SFA_VIP-') === 0) {
                        $prefix = 'Shadow Fight Arena';
                    }

                    if ($prefix) {
                        $info .= "📬 Powered By ActionMods\n\n";
                        $info .= "┇ Information Key : \n\n";
                        $info .= "Key : $key_value\n\n";
                        $info .= "Expired Date : " . date('d - m - Y', strtotime($expiration_date)) . "\n\n";
                        $info .= "Device : $current_usage / $usage_limit 📱\n\n";
                        $info .= "Type Key : " . (strpos($key_input, 'VIP') === 0 ? 'Free' : 'VIP') . "\n\n";
                        $info .= "Game : $prefix \n\n\n";
                        $info .= "┇ Information User : \n\nID : $device_id\n";
                    }
                }
            }
        } else {
            $info .= "┇ No Device Records Found For The Given Key\n";
        }

        if ($info) {
            echo xorEncrypt($info, $key);
        } else {
            echo xorEncrypt("┇ No Record Found For The Given Key\n", $key);
        }

        $stmt_device_info->close();
    } else {
        echo xorEncrypt("┇ No Record Found For The Given Key\n", $key);
    }
    $stmt_key->close();
} else {
    echo xorEncrypt("┇ No Key Provided\n", $key);
}

$conn->close();
?>
