<?php
// Connect Database 
include 'Database.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('HTTP/1.0 403 Forbidden');
    echo "Access denied";
    exit();
}

// Get data from the form
$key_input = $_POST['key'] ?? '';

if ($key_input) {
    // Verify the key
    $sql_key = "SELECT id, usage_limit, expiration_date, current_usage, key_value FROM api_keys WHERE key_value = ?";
    $stmt_key = $conn->prepare($sql_key);
    if (!$stmt_key) {
        die("Error preparing database statement: " . $conn->error);
    }

    $stmt_key->bind_param("s", $key_input);
    $stmt_key->execute();
    $result_key = $stmt_key->get_result();

    if ($result_key->num_rows === 1) {
        $key_data = $result_key->fetch_assoc();
        $key_id = $key_data['id'];
        $key_value = $key_data['key_value'];
        $expiration_date = $key_data['expiration_date'];
        $usage_limit = $key_data['usage_limit'];
        $current_usage = $key_data['current_usage'];

        // Get device information from device_ids associated with the specific key
        $sql_device_info = "SELECT device_id FROM device_ids WHERE api_key_id = ?";
        $stmt_device_info = $conn->prepare($sql_device_info);
        if (!$stmt_device_info) {
            die("Error preparing database statement: " . $conn->error);
        }

        $stmt_device_info->bind_param("i", $key_id);
        $stmt_device_info->execute();
        $result_device_info = $stmt_device_info->get_result();

        if ($result_device_info->num_rows > 0) {
            $device_row = $result_device_info->fetch_assoc();
            $device_id = $device_row['device_id'];

            // Check if the device ID is banned
            $sql_banned = "SELECT ban_reason, banned_at FROM banned_devices WHERE device_id = ?";
            $stmt_banned = $conn->prepare($sql_banned);
            if (!$stmt_banned) {
                die("Error preparing database statement: " . $conn->error);
            }

            $stmt_banned->bind_param("s", $device_id);
            $stmt_banned->execute();
            $result_banned = $stmt_banned->get_result();

            if ($result_banned->num_rows > 0) {
                // If the device is banned, display banned information
                $banned_data = $result_banned->fetch_assoc();
                $ban_reason = $banned_data['ban_reason'];
                $banned_at = $banned_data['banned_at'];
                echo "┇ Detected Your Device Has Been Banned !\n\n";
                echo " ID : $device_id\n\n";
                echo " You Have Been Officially Banned From Our Scenario, If You Have Any Questions Please Contact The Publisher !\n";
                $stmt_banned->close();
                $stmt_device_info->close();
                $stmt_key->close();
                $conn->close();
                exit();
            } else {
                // Check if the key is expired
                if (strtotime($expiration_date) < time()) {
                    echo "┇ Detected The Key Has Expired\n\n";
                    echo " Expiration Date : " . date('d - m - Y', strtotime($expiration_date)) . "\n\n";
                    echo " Current Date : " . date('d - m - Y') . "\n";
                    $stmt_banned->close();
                    $stmt_device_info->close();
                    $stmt_key->close();
                    $conn->close();
                    exit();
                } 

                // Display device information based on the key prefix
                $prefix = '';
                    if (strpos($key_input, 'SF2_FREE-') === 0) {
                        $prefix = 'Shadow Fight 2';
                    } elseif (strpos($key_input, 'SF3_FREE-') === 0) {
                        $prefix = 'Shadow Fight 3';
                    } elseif (strpos($key_input, 'SFA_FREE-') === 0) {
                        $prefix = 'Shadow Fight Arena';
                    } elseif (strpos($key_input, 'SF2_VIP-') === 0) {
                        $prefix = 'Shadow Fight 2';
                    } elseif (strpos($key_input, 'SF3_VIP-') === 0) {
                        $prefix = 'Shadow Fight 3';
                    } elseif (strpos($key_input, 'SFA_VIP-') === 0) {
                        $prefix = 'Shadow Fight Arena';
                    }



                if ($prefix) {
                    echo "📬 System Created By @Xnxx\n\n";
                    echo "┇ Information Key : \n\n";
                    echo " Key : $key_value\n\n";
                    echo " Expired Date : " . date('d - m - Y', strtotime($expiration_date)) . "\n\n";
                    echo " Device : $current_usage / $usage_limit 📱\n\n";
                    echo " Type Key : " . (strpos($key_input, 'VIP') === 0 ? 'FREE' : 'VIP') . "\n\n";
                    echo " Game : $prefix \n\n\n";
                    echo "┇ Information User : \n\n";
                    echo " ID : $device_id\n";
                }
            }
        } else {
            echo "┇ No Device Records Found For The Given Key\n";
        }

        $stmt_device_info->close();
    } else {
        echo "┇ No Record Found For The Given Key\n";
    }
    $stmt_key->close();
} else {
    echo "┇ No Key Provided\n";
}

// Close connection
$conn->close();
?>
