import express from "express";
import cors from "cors";
import bodyParser from "body-parser";

const app = express();
app.use(cors());
app.use(bodyParser.json());
app.use(bodyParser.urlencoded({ extended: true }));

// Fake database (in memory)
const users = {
  "test@example.com": { password: "12345", token: "abc123" },
};

// Login endpoint
app.post("/wp-json/quotex/login-new/", (req, res) => {
  const { email, password, device } = req.body;

  if (users[email] && users[email].password === password) {
    return res.json({
      status: "success",
      token: users[email].token,
      user: { email, device }
    });
  }

  return res.status(401).json({ status: "error", message: "Invalid login" });
});

// Verify endpoint
app.post("/wp-json/quotex/verify-new/", (req, res) => {
  const token = req.headers["authorization"]?.replace("Bearer ", "");
  const { device } = req.body;

  const user = Object.entries(users).find(([email, data]) => data.token === token);

  if (user) {
    return res.json({ status: "valid", email: user[0], device });
  }

  return res.status(403).json({ status: "invalid token" });
});

// Start server
const PORT = process.env.PORT || 3000;
app.listen(PORT, () => {
  console.log(`✅ Auth server running on http://localhost:${PORT}`);
});