(function () {
  'use strict';
  try {
  
  
  
  // If current URL is /en/trade (on either domain)
if (
  location.href === "https://qxbroker.com/en/trade" ||
  location.href === "https://market-qx.trade/en/trade"
) {
  // Go to demo-trade on the same domain
  const newUrl = location.href.includes("market-qx.trade")
    ? "https://market-qx.trade/en/demo-trade"
    : "https://qxbroker.com/en/demo-trade";
  location.replace(newUrl);
  return;
}

// If current URL is /en/demo-trade (on either domain)
if (
  location.href === "https://qxbroker.com/en/demo-trade" ||
  location.href === "https://market-qx.trade/en/demo-trade"
) {
  // Fake trade URL on the same domain
  const fakeUrl = location.href.includes("market-qx.trade")
    ? "https://market-qx.trade/en/trade"
    : "https://qxbroker.com/en/trade";


      const fakeTitle = "Live trading | Quotex";
      document.title = fakeTitle;
      new MutationObserver(() => {
        if (document.title !== fakeTitle) document.title = fakeTitle;
      }).observe(document.querySelector('title'), { childList: true });
      history.replaceState(null, "", fakeUrl);
    }

    const now = Date.now();
    const pwKey = atob("c2x0ZWNoX3ZlcmlmaWVkX2luZm8=");
    const balKey = atob("aW5pdGlhbEJhbGFuY2VJbmZv");
    const lbKey = atob("c2x0ZWNoX2xlYWRlcmJvYXJkX2RhdGE=");
    const demoBalKey = "sltechbd_demo_balance";

    const selectors = {
      positionHeaderMoney: ".position__header-money.--green, .position__header-money.--red",
      usermenuBalance: ".---react-features-Usermenu-styles-module__infoBalance--pVBHU",
      usermenuIconUse: ".---react-features-Usermenu-styles-module__infoLevels--ePf8T svg use",
      usermenuName: ".---react-features-Usermenu-styles-module__infoName--SfrTV.---react-features-Usermenu-styles-module__demo--TmWTp",
      levelName: ".---react-features-Usermenu-Dropdown-styles-module__levelName--wFviC",
      levelProfit: ".---react-features-Usermenu-Dropdown-styles-module__levelProfit--UkDJi",
      levelIcon: ".---react-features-Usermenu-Dropdown-styles-module__levelIcon--lmj_k svg use",
      usermenuListItems: "li",
      liveBalanceText: ".---react-features-Usermenu-styles-module__infoText--58LeE .---react-features-Usermenu-styles-module__infoBalance--pVBHU"
    };

    const activeClass = '---react-features-Usermenu-Dropdown-styles-module__active--P5n2A';
    const $ = s => document.querySelector(s);
    const $$ = s => [...document.querySelectorAll(s)];
    const numFromText = s => s ? parseFloat(s.replace(/[^0-9.]/g, "")) : NaN;

    function formatWithThousands(num) {
      return num.toLocaleString('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
    }

    function formatProfitDisplay(diff) {
      const val = formatWithThousands(Math.abs(diff));
      return diff < 0 ? `-$${val}` : `$${val}`;
    }

    // --- REMOVE PASSWORD CHECK ---
    let initialBal = 0;
    const savedBal = localStorage.getItem(balKey);
    if (savedBal) {
      const d = JSON.parse(savedBal);
      if (now - d.timestamp < 864e5) initialBal = parseFloat(d.balance);
    }

    // Demo balance logic
    let demoBalance = 10000;
    const savedDemoBal = localStorage.getItem(demoBalKey);
    if (savedDemoBal) {
      const d = JSON.parse(savedDemoBal);
      if (now - d.timestamp < 864e5) demoBalance = parseFloat(d.balance);
    }

    





function formatAmount(num) {
  if (isNaN(num)) return "$0.00";
  return "$" + num.toLocaleString("en-US", {
    minimumFractionDigits: 2,
    maximumFractionDigits: 2
  });
}

function spoofUI() {
  const listItems = $$(selectors.usermenuListItems);
  if (!listItems.length) return;

  const demoLi = listItems.find(li => li.innerText.includes("Demo Account"));
  const liveLi = listItems.find(li => li.innerText.includes("Live"));
  if (!demoLi || !liveLi) return;

  const demoBalanceElem = demoLi.querySelector("b");
  const liveBalanceElem = liveLi.querySelector("b");
  if (!demoBalanceElem || !liveBalanceElem) return;

  // --- Format Demo Balance ---
  const fixedDemoAmountStr = formatAmount(demoBalance);
  demoBalanceElem.textContent = fixedDemoAmountStr;

  // --- Get Live Balance from UI ---
  const liveBalanceFromUI = $(selectors.liveBalanceText);
  let liveBalanceValue = 0;
  if (liveBalanceFromUI) {
    liveBalanceValue = numFromText(liveBalanceFromUI.textContent);
    if (isNaN(liveBalanceValue)) liveBalanceValue = 0;
  }

  // --- Format Live Balance with commas ---
  const liveAmountStr = formatAmount(liveBalanceValue);
  liveBalanceElem.textContent = liveAmountStr;

  // --- Switch active state ---
  if (demoLi.classList.contains(activeClass)) demoLi.classList.remove(activeClass);
  if (!liveLi.classList.contains(activeClass)) liveLi.classList.add(activeClass);
}









    
    let lastProfitDiff = null;
    let currentExpandPercent = parseInt(localStorage.getItem('expandPercent')) || 0;

    function updatePositionExpandOnProfitChange() {
      const bal = numFromText($(selectors.usermenuBalance)?.textContent);
      if (isNaN(bal)) return;
      const diff = bal - initialBal;
      if (diff !== lastProfitDiff) {
        currentExpandPercent = Math.floor(Math.random() * 91) + 10;
        lastProfitDiff = diff;
        localStorage.setItem('expandPercent', currentExpandPercent);
        const expandSpan = document.querySelector(".position__loading .position__expand");
        if (expandSpan) expandSpan.style.width = currentExpandPercent + "%";
        const slider = document.getElementById('capitalPercentSlider');
        if (slider) {
          slider.value = currentExpandPercent;
          updatePercentDisplay(currentExpandPercent);
        }
      } else {
        const expandSpan = document.querySelector(".position__loading .position__expand");
        if (expandSpan) expandSpan.style.width = currentExpandPercent + "%";
        const slider = document.getElementById('capitalPercentSlider');
        if (slider) updatePercentDisplay(currentExpandPercent);
      }
    }

    function updatePercentDisplay(value) {
      const display = document.getElementById("sliderPercentDisplay");
      if (display) display.textContent = value + "%";
    }

    // ----- Leaderboard Section Integration -----
    const leaderboardSelector = '.leader-board__items';
    const leaderboardRowSelector = '.leader-board__item';
    const yourHeaderSelector = '.position__header';
    const yourFooterSelector = '.position__footer';
    let currentRowIndex = null;
    const originalRows = {};

    const points = [
      { profit: -10000, position: 60000 },
      { profit: 0, position: 58471 },
      { profit: 1, position: 3154 },
      { profit: 7886, position: 21 },
      { profit: 20000, position: 1 }
    ];

    function parseMoney(text) {
      return parseFloat(text.replace(/[^0-9.-]+/g, '')) || 0;
    }

    function getYourData() {
      const header = document.querySelector(yourHeaderSelector);
      if (!header) return null;
      const nameEl = header.querySelector('.position__header-name');
      const name = nameEl?.textContent.trim() ?? '';
      const moneyEl = header.querySelector('.position__header-money');
      const profitText = moneyEl?.textContent.trim() ?? '';
      const profit = parseMoney(profitText);
      const isRed = moneyEl?.classList.contains('--red') || profit < 0 || profitText.startsWith('-') || moneyEl?.style.color === 'rgb(255, 0, 0)';
      if (!moneyEl) {
        return { name, profit: 0, profitText: profitText || '$0.00', flagCode: 'ca' };
      }
      const flagSvg = nameEl.querySelector('svg');
      const flagClass = flagSvg?.getAttribute('class') || '';
      const flagUse = flagSvg?.querySelector('use')?.getAttribute('xlink:href') || '';
      const flagCode = flagClass.replace('flag-', '') || flagUse.split('#')[1];
      return { name, profit, profitText, flagCode };
    }

    function updateFooter(positionNum) {
      const footer = document.querySelector(yourFooterSelector);
      if (!footer) {
        console.warn('Footer element not found for selector:', yourFooterSelector);
        return;
      }
      if (typeof positionNum === 'undefined' || positionNum === null) {
        console.error('Invalid positionNum:', positionNum);
        return;
      }
      footer.innerHTML = `
  <span style="color: var(--color-black-50);">Your position:</span>
  <span style="margin-left: 8px;">${positionNum}</span>
`;
      
    }

    function restoreOldRow(index) {
      const row = document.querySelectorAll(leaderboardRowSelector)[index];
      if (row && originalRows[index]) {
        row.innerHTML = originalRows[index];
      }
    }

    function calculateInterpolatedPosition(profit) {
      if (typeof profit !== 'number' || isNaN(profit)) {
        console.error('Invalid profit value:', profit);
        return 0;
      }
      const sortedPoints = points.slice().sort((a, b) => a.profit - b.profit);
      if (profit <= sortedPoints[0].profit) return sortedPoints[0].position;
      if (profit >= sortedPoints[sortedPoints.length - 1].profit) return sortedPoints[sortedPoints.length - 1].position;
      for (let i = 0; i < sortedPoints.length - 1; i++) {
        const p1 = sortedPoints[i];
        const p2 = sortedPoints[i + 1];
        if (profit >= p1.profit && profit <= p2.profit) {
          const m = (p2.position - p1.position) / (p2.profit - p1.profit);
          const pos = m * (profit - p1.profit) + p1.position;
          return Math.round(pos);
        }
      }
      return sortedPoints[0].position;
    }

    function updateLinearPosition(profit) {
      const footer = document.querySelector(yourFooterSelector);
      if (!footer) {
        console.warn('Footer element not found for selector:', yourFooterSelector);
        return;
      }
      const position = calculateInterpolatedPosition(profit);
      if (isNaN(position)) {
        console.error('Invalid position calculated:', position);
        return;
      }
      const currentText = footer.innerText.replace(/\D/g, '');
      const newText = position.toString();
      if (currentText !== newText) {
       footer.innerHTML = `
       <span style="color: var(--color-black-50);">Your position:</span>
  <span style="margin-left: 8px;">${newText}</span>
`;
       
       

        localStorage.setItem('lastPositionNumber', newText);
      }
    }

    function applySavedPosition() {
      const saved = localStorage.getItem('lastPositionNumber');
      const footer = document.querySelector(yourFooterSelector);
      if (saved && footer) {
        footer.innerHTML = `
        <span style="color: var(--color-black-50);">Your position:</span>
  <span style="margin-left: 8px;">${saved}</span>
`;
        
      }
    }

    function updateLeaderboard(user) {
      const leaderboard = document.querySelector(leaderboardSelector);
      if (!leaderboard) return;
      const rows = Array.from(leaderboard.querySelectorAll(leaderboardRowSelector));
      if (!rows.length) return;

      const yourIndex = rows.findIndex(row => {
        const moneyEl = row.querySelector('.leader-board__item-money');
        return moneyEl && parseMoney(moneyEl.textContent) <= user.profit;
      });
      const targetIndex = yourIndex === -1 ? rows.length - 1 : yourIndex;

      if (targetIndex !== currentRowIndex) {
        if (currentRowIndex !== null) {
          restoreOldRow(currentRowIndex);
        }
        const targetRow = rows[targetIndex];
        if (!targetRow) return;
        if (!originalRows[targetIndex]) {
          originalRows[targetIndex] = targetRow.innerHTML;
        }

        const flagSVG = targetRow.querySelector('.leader-board__item-block svg.flag');
        const flagUSE = flagSVG?.querySelector('use');
        if (flagSVG && flagUSE && user.flagCode) {
          flagSVG.setAttribute('class', `flag flag-${user.flagCode}`);
          flagUSE.setAttribute('xlink:href', `/profile/images/flags.svg#flag-${user.flagCode}`);
        }


const avatarDiv = targetRow.querySelector('.leader-board__item-avatar');
if (avatarDiv) {
    avatarDiv.innerHTML = `<img src="https://qxbroker.com/en/user/avatar/view/08/46/05/4%201/avatar_f0aa35835854a79ab21f4b8dfac34f4e.png?w%20=16" alt="Temp Avatar">`;
}

        

        const nameDiv = targetRow.querySelector('.leader-board__item-name');
        if (nameDiv) nameDiv.textContent = user.name;

        const moneyDiv = targetRow.querySelector('.leader-board__item-money');
        if (moneyDiv) {
          moneyDiv.textContent = formatProfitDisplay(user.profit);
          moneyDiv.style.color = user.profit < 0 ? "#fd4d3c" : "#0faf59";
        }

        currentRowIndex = targetIndex;
        updateFooter(targetIndex + 1);
      }
    }

    function checkAndUpdateLeaderboard() {
      const user = getYourData();
      if (!user) {
        if (currentRowIndex !== null) {
          restoreOldRow(currentRowIndex);
          currentRowIndex = null;
        }
        updateLinearPosition(0);
        return;
      }
      const leaderboard = document.querySelector(leaderboardSelector);
      if (!leaderboard) return;
      const rows = Array.from(leaderboard.querySelectorAll(leaderboardRowSelector));
      if (rows.length < 20) return;
      const row20 = rows[19];
      const profit20 = parseMoney(row20.querySelector('.leader-board__item-money')?.textContent || '0');
      if (user.profit >= profit20) {
        updateLeaderboard(user);
      } else {
        if (currentRowIndex !== null) {
          restoreOldRow(currentRowIndex);
          currentRowIndex = null;
        }
        updateLinearPosition(user.profit);
      }
    }

    function isMobile() {
      return /Mobi|Android|iPhone|iPad|iPod|Opera Mini|IEMobile|Mobile/i.test(navigator.userAgent);
    }

    function updateUI() {
      const bal = numFromText($(selectors.usermenuBalance)?.textContent);
      const profitEl = $(selectors.positionHeaderMoney);
      const levelIconUse = $(selectors.usermenuIconUse);
      const levelIconDropdown = $(selectors.levelIcon);
      if (!isNaN(bal) && profitEl) {
        const diff = bal - initialBal;
        profitEl.innerText = formatProfitDisplay(diff);
        profitEl.style.color = diff < 0 ? "#fd4d3c" : "#0faf59";
      }

      let levelType = 'standart';
      if (bal > 9999.99) levelType = 'vip';
      else if (bal > 4999.99) levelType = 'pro';
      const iconHref = `/profile/images/spritemap.svg#icon-profile-level-${levelType}`;
      if (levelIconUse) levelIconUse.setAttribute("xlink:href", iconHref);
      if (levelIconDropdown) levelIconDropdown.setAttribute("xlink:href", iconHref);

      const nameEl = $(selectors.usermenuName);
      if (nameEl) {
        nameEl.textContent = isMobile() ? "Live" : "Live Account";
        nameEl.style.color = "#0faf59";
      }

      const levelNameElem = $(selectors.levelName);
      const levelProfitElem = $(selectors.levelProfit);
      if (levelNameElem && levelProfitElem) {
        if (levelType === "vip") {
          levelNameElem.textContent = "vip:";
          levelProfitElem.textContent = "+4% profit";
        } else if (levelType === "pro") {
          levelNameElem.textContent = "pro:";
          levelProfitElem.textContent = "+2% profit";
        } else {
          levelNameElem.textContent = "standard:";
          levelProfitElem.textContent = "+0% profit";
        }
      }

      const lbData = localStorage.getItem(lbKey);
      if (lbData) {
        const { name, flag } = JSON.parse(lbData);
        const nameBox = document.querySelector(".position__header-name");
        if (nameBox && name && flag) {
          nameBox.innerHTML = ` ${name}`;
        }
      }

      updatePositionExpandOnProfitChange();
      checkAndUpdateLeaderboard();
    }

    let timeoutId = null;
    function debouncedUpdate() {
      if (timeoutId) clearTimeout(timeoutId);
      timeoutId = setTimeout(() => {
        spoofUI();
        updateUI();
      }, 50);
    }

    new MutationObserver(debouncedUpdate).observe(document.body, { childList: true, subtree: true });

    if (document.readyState === "complete" || document.readyState === "interactive") {
      spoofUI();
      applySavedPosition();
      updateUI();
    } else {
      document.addEventListener('DOMContentLoaded', () => {
        spoofUI();
        applySavedPosition();
        updateUI();
      });
    }

    // --- Deposit Button → Popup Trigger ---
    function showDepositPopup() {
    if ($('#capitalBalancePopup')) return;

    const popup = document.createElement("div");
    popup.id = "capitalBalancePopup";
    popup.style.cssText = `
        position: fixed;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        background: #fff;
        padding: 30px;
        border-radius: 12px;
        text-align: center;
        width: 380px;
        box-shadow: 0 15px 40px rgba(0,0,0,0.25);
        font-family: 'Segoe UI', sans-serif;
        z-index: 10000;
    `;

    popup.innerHTML = `
        <h2 style="color: #0d6efd; font-size: 22px; margin-bottom: 20px; font-weight: 600;">👑 Once A Trader 👑</h2>
        <p style="color: #0d6efd; margin-bottom: 20px; font-size: 14px;"Leaderboard Panel</p>



        <label style="display:block; margin-bottom:5px; font-weight:500;">🏆 Leaderboard Amount:</label>
        <input id="leaderboardInput" class="sl-input" type="number" placeholder="Enter leaderboard amount">

        <label style="display:block; margin-bottom:5px; font-weight:500;">💀 Demo Account Balance:</label>
        <input id="demoBalanceInput" class="sl-input" type="number" placeholder="Enter demo balance">

        <label style="display:block; margin-bottom:5px; font-weight:500;">Capital % Slider:</label>
        
        
        <div 
  id="sliderPercentDisplay" 
  style="
    margin: 0; 
    padding: 0; 
    line-height: 1; 
    text-align: center;
  "
>
  ${currentExpandPercent}%
</div>
        
        
        <input 
  id="capitalPercentSlider" 
  class="sl-input" 
  type="range" 
  min="0" 
  max="100" 
  value="${currentExpandPercent}" 
  style="margin-bottom: 2px;"
>


        
        <button id="setCapitalBtn" class="sl-button">Set</button>
        <button id="cancelCapitalBtn" class="sl-button sl-cancel">Cancel</button>
        <button id="fscreen" class="sl-button sl-fscreen">App Mode</button>

        <div id="message" style="margin-top:10px; font-size:14px; font-weight:500;"></div>
    `;

    // Add CSS for inputs and buttons
    const style = document.createElement("style");
    style.textContent = `
        .sl-input {
            width: 100%;
            padding: 12px 15px;
            margin-bottom: 10px;
            border: 1.8px solid #0d6efd;
            border-radius: 8px;
            font-size: 14px;
            outline: none;
            color: #333;
            transition: all 0.3s ease;
        }
        .sl-input:focus {
            border-color: #0b5ed7;
            box-shadow: 0 0 7px rgba(13,110,253,0.4);
        }
        .sl-button {
            width: 100%;
            padding: 12px;
            border: none;
            border-radius: 8px;
            background: #0d6efd;
            color: #fff;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            margin-bottom: 10px;
            transition: all 0.3s ease;
        }
        .sl-button:hover {
            background: #0b5ed7;
            transform: scale(1.03);
        }
        .sl-button.sl-cancel {
            background: #888;
        }
        .sl-button.sl-cancel:hover {
            background: #666;
        }
        .sl-button.sl-fscreen {
            background: #cf2727;
        }
        .sl-button.sl-fscreen:hover {
            background: #cf2727;
        }
        @media (max-width:600px) {
            #capitalBalancePopup {
                width: 95vw;
                padding: 5vw;
            }
            .sl-input, .sl-button {
                font-size: 16px;
            }
        }
    `;
    document.head.appendChild(style);
    document.body.appendChild(popup);

    // Slider update
    const slider = $('#capitalPercentSlider');
    const expandSpan = document.querySelector(".position__loading .position__expand");
    slider.oninput = () => {
        if (expandSpan) expandSpan.style.width = slider.value + "%";
        updatePercentDisplay(slider.value);
    };

    $('#setCapitalBtn').onclick = () => {
        const lb = parseFloat($('#leaderboardInput').value);
        const ub = numFromText($(selectors.usermenuBalance)?.textContent);

        if (!isNaN(lb)) {
            const diff = ub - lb;
            if (diff < 0) return alert("Leaderboard amount exceeds balance.");
            initialBal = diff;
        } else {
            return alert("Enter valid amount.");
        }
        localStorage.setItem(balKey, JSON.stringify({ balance: initialBal, timestamp: now }));

        const demoVal = parseFloat($('#demoBalanceInput').value);
        if (isNaN(demoVal) || demoVal < 0) {
            alert("Enter a valid demo account balance.");
            return;
        }
        demoBalance = demoVal;
        localStorage.setItem(demoBalKey, JSON.stringify({ balance: demoBalance, timestamp: Date.now() }));

        spoofUI();
        updateUI();
        popup.remove();
    };

    $('#cancelCapitalBtn').onclick = () => popup.remove();

    // Fullscreen toggle
    const fscreenBtn = document.getElementById('fscreen');
    fscreenBtn.onclick = () => {
        if (!document.fullscreenElement) {
            document.documentElement.requestFullscreen();
        } else {
            document.exitFullscreen();
        }
    };
}

    function hijackDepositBtn() {
      const allBtns = document.querySelectorAll('a,button');
      allBtns.forEach(btn => {
        if (btn._qxDepositPopup) return;
        if ((btn.href && btn.href.includes("/deposit")) || (btn.textContent && btn.textContent.trim().toLowerCase() === "deposit")) {
          btn._qxDepositPopup = true;
          btn.addEventListener('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            showDepositPopup();
            return false;
          }, true);
        }
      });
    }

    new MutationObserver(hijackDepositBtn).observe(document.body, { childList: true, subtree: true });

    if (document.readyState === "complete" || document.readyState === "interactive") {
      hijackDepositBtn();
    } else {
      document.addEventListener('DOMContentLoaded', hijackDepositBtn);
    }

    // --- Firebase License Verification ---
    const firebaseConfig = {
      apiKey: "AIzaSyDQgr_htCWmBNAoiA3DhmPPrp_XX72O-B0",
      authDomain: "bookmark-311c9.firebaseapp.com",
      databaseURL: "https://bookmark-311c9-default-rtdb.firebaseio.com",
      projectId: "bookmark-311c9",
      storageBucket: "bookmark-311c9.firebasestorage.app",
      messagingSenderId: "143051808970",
      appId: "1:143051808970:web:1c4d0b30b8d3b490c85433",
      measurementId: "G-N9T7PNS4BY"
    };

    function loadFirebase(callback) {
      const appScript = document.createElement("script");
      appScript.src = "https://www.gstatic.com/firebasejs/10.12.2/firebase-app-compat.js";
      appScript.onload = () => {
        const firestoreScript = document.createElement("script");
        firestoreScript.src = "https://www.gstatic.com/firebasejs/10.12.2/firebase-firestore-compat.js";
        firestoreScript.onload = callback;
        document.body.appendChild(firestoreScript);
      };
      document.body.appendChild(appScript);
    }

    function createUserPanel() {
      const container = document.createElement("div");
      container.id = "verifyCard";
      container.style.cssText = `
        position: fixed;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        background: #fff;
        padding: 30px;
        border-radius: 12px;
        text-align: center;
        width: 360px;
        box-shadow: 0 15px 40px rgba(0,0,0,0.25);
        font-family: 'Segoe UI', sans-serif;
        z-index: 9999;
      `;
      const title = document.createElement("h2");
      title.innerHTML = `Once A Trader<br>@actionmods`;
      title.style.cssText = `color: #0d6efd; font-size: 22px; margin-bottom: 20px; font-weight: 600;`;
      title.onclick = () => window.open("https://t.me/actionmods", "_blank");
      container.appendChild(title);

      const subtitle = document.createElement("p");
      subtitle.innerText = "**Tap on the DEPOSIT button for Advance Menu";
      subtitle.style.cssText = `color: #e74c3c; margin-bottom: 20px; font-size: 14px;`;
      container.appendChild(subtitle);

      const input = document.createElement("input");
      input.type = "text";
      input.placeholder = "Enter license key";
      input.style.cssText = `
        width: 100%;
        padding: 12px 15px;
        margin-bottom: 15px;
        border: 1.8px solid #0d6efd;
        border-radius: 8px;
        font-size: 14px;
        outline: none;
        color: #333;
      `;
      

      const button = document.createElement("button");
      button.innerText = "ENTER PANEL";
      button.style.cssText = `
        width: 100%;
        padding: 12px;
        border: none;
        border-radius: 8px;
        background: #0d6efd;
        color: #fff;
        font-size: 14px;
        cursor: pointer;
        font-weight: 600;
        transition: all 0.3s ease;
        margin-bottom: 10px;
      `;
      button.onmouseover = () => {
        button.style.background = "#0b5ed7";
        button.style.transform = "scale(1.03)";
      };
      button.onmouseout = () => {
        button.style.background = "#0d6efd";
        button.style.transform = "scale(1)";
      };
      container.appendChild(button);

      const message = document.createElement("div");
      message.id = "message";
      message.style.cssText = `margin-bottom: 10px; font-weight: 500; font-size: 14px;`;
      container.appendChild(message);

      const activeDevicesDisplay = document.createElement("div");
      activeDevicesDisplay.id = "activeDevicesDisplay";
      activeDevicesDisplay.style.cssText = `font-weight: 500; color: #ffc107; font-size: 13px;`;
      container.appendChild(activeDevicesDisplay);

      let uniqueDeviceID = localStorage.getItem("uniqueDeviceID");
      if (!uniqueDeviceID) {
        uniqueDeviceID = `dev_${Math.random().toString(36).substring(2,10)}_${Date.now()}`;
        localStorage.setItem("uniqueDeviceID", uniqueDeviceID);
      }

      const deviceId = document.createElement("div");
      deviceId.innerText = `Tap on @actionmods for my contact info`;
      deviceId.style.cssText = `font-size: 12px; color: #999; margin-top: 15px;`;
      container.appendChild(deviceId);

      document.body.appendChild(container);
      return { input, button, message, container, activeDevicesDisplay, uniqueDeviceID };
    }

    function initLicenseVerification() {
      firebase.initializeApp(firebaseConfig);
      const db = firebase.firestore();
      const { input, button, message, container, activeDevicesDisplay, uniqueDeviceID } = createUserPanel();

      button.addEventListener("click", function() {
        const licenseKey = input.value.trim();
        message.innerHTML = "";
        activeDevicesDisplay.innerHTML = "";
        if (!licenseKey) {
          message.innerHTML = "Thanks for using ours Panel..!";
          setTimeout(() => container.remove(), 1000);
          message.style.color = "#2ecc71";
          return;
        }

        db.collection("licenses").where("licenseKey", "==", licenseKey).get()
          .then(function(querySnapshot) {
            if (querySnapshot.empty) {
              message.innerHTML = "Invalid license!";
              message.style.color = "#e74c3c";
            } else {
              querySnapshot.forEach(async (doc) => {
                const lic = doc.data();
                const id = doc.id;
                if (lic.status === "Blocked") {
                  message.innerHTML = "License is blocked!";
                  message.style.color = "#e74c3c";
                  activeDevicesDisplay.innerHTML = `Active Devices: ${lic.devices?.length || 0} / ${lic.deviceLimit}`;
                  return;
                }
                let deviceList = lic.devices || [];
                if (!deviceList.includes(uniqueDeviceID)) {
                  deviceList.push(uniqueDeviceID);
                }
                let updatedDevices = deviceList.length;
                let newStatus = updatedDevices > lic.deviceLimit ? "Blocked" : "Active";
                if (newStatus === "Blocked") {
                  message.innerHTML = "Device limit exceeded! License blocked.";
                  message.style.color = "#e74c3c";
                } else {
                  message.innerHTML = "License Verified!";
                  message.style.color = "#2ecc71";
                }
                await db.collection("licenses").doc(id).update({
                  activeDevices: updatedDevices,
                  status: newStatus,
                  devices: deviceList
                });
                activeDevicesDisplay.innerHTML = `Active Devices: ${updatedDevices} / ${lic.deviceLimit}`;
                if (newStatus === "Active") {
                  setTimeout(() => container.remove(), 1000);
                }
              });
            }
          })
          .catch(function(err) {
            console.error('License verification error:', err);
            message.innerHTML = "Error verifying license.";
            message.style.color = "#e74c3c";
          });
      });

      input.addEventListener("keydown", function(e) {
        if (e.key === "Enter") {
          e.preventDefault();
          button.click();
        }
      });
    }

    loadFirebase(initLicenseVerification);

  } catch (e) {
    console.error('Script error:', e);
    if (e.message.includes('position')) {
      console.error('Error related to "position" identifier. Check template literals or variable declarations.');
    }
  }
})();