let lname = "CratE"; // Username
let iblafp = "1"; // Initial balance
let flagCode = "flag-in"; // Flag identifier


// Replace "Demo" with "Live" in document title
document.title = document.title.replace("Demo", "Live");

// Update user profile based on balance
function changeUserIconInside() {
  let balanceElement = document.getElementsByClassName("---react-features-Usermenu-styles-module__infoBalance--pVBHU")[0];
  if (!balanceElement) return;

  let balanceText = balanceElement.textContent;
  let balance = parseInt(balanceText.replace(",", "").replace("$", "").replace(".", ""));
  balance = balanceText.substring(0, balanceText.length - 2);
  balance = parseInt(balance);

  let levelIcon, levelName, levelSvg;
  if (balance < 5000) {
    levelIcon = "STANDARD:";
    levelName = "+0% profit";
    levelSvg = '<svg class="icon-profile-level-standart"><use xlink:href="/profile/images/spritemap.svg#icon-profile-level-standart"></use></svg>';
  } else if (balance >= 5000 && balance < 10000) {
    levelIcon = "PRO:";
    levelName = "+2% profit";
    levelSvg = '<svg class="icon-profile-level-standart"><use xlink:href="/profile/images/spritemap.svg#icon-profile-level-pro"></use></svg>';
  } else {
    levelIcon = "VIP:";
    levelName = "+4% profit";
    levelSvg = '<svg class="icon-profile-level-standart"><use xlink:href="/profile/images/spritemap.svg#icon-profile-level-vip"></use></svg>';
  }

  let userMenu = document.getElementsByClassName("---react-features-Usermenu-Dropdown-styles-module__dropdown--AishB")[0];
  if (userMenu) {
    document.getElementsByClassName("---react-features-Usermenu-Dropdown-styles-module__levelIcon--lmj_k")[0].innerHTML = levelSvg;
    document.getElementsByClassName("---react-features-Usermenu-Dropdown-styles-module__levelName--wFviC")[0].innerHTML = levelIcon;
    document.getElementsByClassName("---react-features-Usermenu-Dropdown-styles-module__levelProfit--UkDJi")[0].innerHTML = levelName;

    let selectBalance = document.getElementsByClassName("---react-features-Usermenu-Dropdown-styles-module__selectBalance--IfQIW");
    if (selectBalance.length >= 1) selectBalance[0].innerHTML = balanceElement.textContent;
    if (selectBalance.length >= 2) selectBalance[1].innerHTML = "$10,000.00";

    let firstElement = document.getElementsByClassName("---react-features-Usermenu-Dropdown-styles-module__selectItem--CWnO_ ---react-features-Usermenu-Dropdown-styles-module__selectItemRadio--GFHcW")[0];
    firstElement.setAttribute("id", "real1");
    let secondElement = document.getElementsByClassName("---react-features-Usermenu-Dropdown-styles-module__selectItem--CWnO_ ---react-features-Usermenu-Dropdown-styles-module__selectItemRadio--GFHcW")[1];
    secondElement.setAttribute("id", "demo1");
    let real1Element = document.getElementById("real1");
    real1Element.classList.add("---react-features-Usermenu-Dropdown-styles-module__active--P5n2A");
    let demo1Element = document.getElementById("demo1");
    demo1Element.classList.remove("---react-features-Usermenu-Dropdown-styles-module__active--P5n2A");
  }
}

// Update profile icon based on balance


// Create a notification div that fades out
(function () {
  const div = document.createElement("div");
  div.textContent = "Panel Made by @actionmods";
  div.style.position = "absolute";
  div.style.top = "50%";
  div.style.left = "50%";
  div.style.transform = "translateX(-50%)";
  div.style.background = "var(--color-black-15)";
  div.style.padding = "10px 20px";
  div.style.zIndex = "10000";
  div.style.fontFamily = "Arial, sans-serif";
  div.style.fontSize = "16px";
  div.style.opacity = "1";
  div.style.color = "white";
  document.body.appendChild(div);
  setTimeout(() => {
    div.style.opacity = "0";
    setTimeout(() => div.remove(), 2000);
  }, 2000);
})();

// Monitor DOM changes for profile updates

// Main app script to modify UI
function executeAppScript() {
  document.title = document.title.replace("Demo", "LIVE ACCOUNT");

  // Inject CSS to remove transitions
  const style = document.createElement("style");
  style.textContent = `
    .usermenu__select-item--radio .usermenu__select-name:before,
    .usermenu__select-item--radio .usermenu__select-name:after {
      -webkit-transition: none !important;
      transition: none !important;
      -webkit-transition-property: none !important;
      transition-property: none !important;
    }
  `;
  document.head.appendChild(style);

  window.history.pushState({}, "", "/en/trade");

  // Remove banner
  const banner = document.querySelector(".---react-features-Header-Banner-styles-module__banner--yFUko");
  if (banner) banner.remove();

  // Update user menu text
  const isMobile = /Android|webOS|iPhone|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);
  const classes = [
    ".usermenu__info-name.demo, ",
    "usermenu__info-name",
    "usermenu-mobile__info-name",
    ".---react-features-Usermenu-Mobile-styles-module__infoName--gG3dg.---react-features-Usermenu-Mobile-styles-module__demo--yQ5k8",
  ];
  classes.forEach((cls) => {
    const element = document.getElementsByClassName(cls)[0];
    if (element && element.textContent.trim().includes("Demo")) {
      element.textContent = isMobile ? "LIVE ACCOUNT" : "LIVE";
    }
  });

  // Update user menu colors
  const userMenus = document.querySelectorAll(
    ".usermenu__info-name.demo, .usermenu-mobile__info-name.demo, .---react-features-Usermenu-styles-module__infoName--SfrTV.---react-features-Usermenu-styles-module__demo--TmWTp, .---react-features-Usermenu-Mobile-styles-module__infoName--gG3dg"
  );
  userMenus.forEach((menu) => {
    menu.style.color = "#00ad67";
  });
}

// Update profile icon for USD balance
function getSvgForProfileIconUsd(balance) {
  if (balance < 5000) {
    return '<svg class="icon-profile-level-standart"><use xlink:href="/profile/images/spritemap.svg#icon-profile-level-standart"></use></svg>';
  } else if (balance >= 5000 && balance < 10000) {
    return '<svg class="icon-profile-level-standart"><use xlink:href="/profile/images/spritemap.svg#icon-profile-level-pro"></use></svg>';
  } else {
    return '<svg class="icon-profile-level-standart"><use xlink:href="/profile/images/spritemap.svg#icon-profile-level-vip"></use></svg>';
  }
}

function updateProfileIconUsd() {
  try {
    const balanceElement = document.getElementsByClassName("---react-features-Usermenu-styles-module__infoBalance--pVBHU")[0];
    const levelElements = document.querySelectorAll(".---react-features-Usermenu-styles-module__infoLevels--ePf8T");
    const mobileLevelElements = document.querySelectorAll(".---react-features-Usermenu-Mobile-styles-module__infoLevels--i4mrD");
    let balanceText = balanceElement.textContent || "";
    balanceText = balanceText.replace(",", "").replace("$", "").replace(".", "");
    if (balanceText.length >= 2) {
      balanceText = balanceText.substring(0, balanceText.length - 2);
      const balance = parseInt(balanceText);
      console.log("parsed balance", balance);
      if (!isNaN(balance)) {
        const svg = getSvgForProfileIconUsd(balance);
        levelElements.forEach((el) => (el.innerHTML = svg));
        mobileLevelElements.forEach((el) => (el.innerHTML = svg));
      }
    }
  } catch (err) {
    console.error("Balance parsing failed:", err);
  }
}

// Monitor balance changes
function watchBalanceChanges() {
  const balanceElement = document.getElementsByClassName("---react-features-Usermenu-styles-module__infoBalance--pVBHU")[0];
  if (!balanceElement) {
    console.log("Balance element not found");
    return;
  }
  console.log("Initial balance value:", balanceElement.textContent);
  const balanceObserver = new MutationObserver((mutations) => {
    mutations.forEach(() => {
      console.log("Balance changed to:", balanceElement.textContent);
      executeAppScript();
      updateProfileIconUsd();
      changeUserIconInside();
    });
  });
  balanceObserver.observe(balanceElement, {
    childList: true,
    characterData: true,
    subtree: true,
    attributes: true,
  });
  console.log("Observer started watching for changes");
  window.balanceObserver = balanceObserver;
  return balanceObserver;
}

// Update leaderboard position


// Update leaderboard values

  // Parse leaderboard balances


// Monitor DOM for leaderboard updates
const consolidatedObserver = new MutationObserver((mutations) => {
  const addedNodes = [];
  mutations.forEach((mutation) => {
    if (mutation.type === "childList" && mutation.addedNodes.length > 0) {
      addedNodes.push(...mutation.addedNodes);
    }
  });
  if (addedNodes.length > 0) processAddedElements(addedNodes);
});

function processAddedElements(nodes) {
  nodes.forEach((node) => {
    if (node.nodeType !== Node.ELEMENT_NODE) return;
    let leaderboardItem = node.classList?.contains("leader-board__item") ? node : node.querySelector(".leader-board__item");
    if (leaderboardItem) {
      console.log("leader-board item detected and added to DOM!");
      const count = document.querySelectorAll(".leader-board__item").length;
      console.log("Total panel-leader-board items: ", count);
      if (count >= 20) requestAnimationFrame(() => updateLeaderBoardValues());
    }
    let userMenu = node.classList?.contains("---react-features-Usermenu-Dropdown-styles-module__dropdown--AishB") ? node : node.querySelector(".---react-features-Usermenu-Dropdown-styles-module__dropdown--AishB");
    if (userMenu) {
      console.log("usermenu__dropdown detected and added to DOM!");
      changeUserIconInside();
    }
  });
}

consolidatedObserver.observe(document.body, { childList: true, characterData: true, subtree: true });

// Execute main functions

