<?php
session_start();
error_reporting(0);

$ADMIN_PASSWORD = "admin123"; 
$FILE_DB = "UserInfoo.json";
$FILE_LOG = "LogCat.txt";
$FILE_LOGIN_LOG = "LoginLogs.txt"; 
date_default_timezone_set('Asia/Kolkata');

function soham_decode($Str){ if($Str == "" || $Str == null) return $Str; $Base = ""; $Count = 1; for($x=0;$x<strlen($Str)/ 2;$x++){ $Base =$Base.chr(hexdec($Str[$Count - 1].$Str[$Count]) - 40); $Count = $Count + 2; } return base64_decode($Base); }
function soham_encode($Str){ if($Str == null) return ""; $Base = base64_encode($Str); $Text = ""; for($x=0;$x < strlen($Base);$x++){ $Text = $Text.dechex(ord($Base[$x])+40); } return $Text; }
function addLog($action, $details){ global $FILE_LOG; $current = soham_decode(file_get_contents($FILE_LOG)); $entry = "\n[".date('d-m-Y H:i')."] ACTION: $action | $details"; file_put_contents($FILE_LOG, soham_encode($current . $entry)); }


if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$error_msg = "";

if (isset($_POST['login'])) {
    $pass = $_POST['password'] ?? '';
    
    if ($pass === $ADMIN_PASSWORD) {
        session_regenerate_id(true);
        $_SESSION['admin_logged_in'] = true;
        header("Location: " . $_SERVER['PHP_SELF']);
        exit();
    } else {
        sleep(1); 
        $error_msg = "Invalid credentials.";
    }
}

if (isset($_GET['logout'])) {
    session_destroy();
    header("Location: " . $_SERVER['PHP_SELF']);
    exit();
}

if (!isset($_SESSION['admin_logged_in'])) {
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Admin Portal</title>
    <style>
        :root {
            --bg: #0f172a;
            --card-bg: #1e293b;
            --text-main: #f8fafc;
            --text-muted: #94a3b8;
            --primary: #6366f1;
            --primary-hover: #4f46e5;
            --danger: #ef4444;
            --border: #334155;
            --input-bg: #0f172a;
        }

        * { box-sizing: border-box; -webkit-tap-highlight-color: transparent; }
        
        body {
            background-color: var(--bg);
            color: var(--text-main);
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
            height: 100vh;
            margin: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px; /* Prevent edge touching on mobile */
        }

        .card {
            width: 100%;
            max-width: 380px; /* Optimal width for login forms */
            background: var(--card-bg);
            padding: 40px 30px;
            border-radius: 20px;
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.6);
            border: 1px solid var(--border);
            text-align: center;
        }

        .icon-lock {
            width: 50px;
            height: 50px;
            background: rgba(99, 102, 241, 0.15);
            border-radius: 14px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
            color: var(--primary);
        }

        h2 { margin: 0 0 8px; font-weight: 700; font-size: 22px; }
        p.subtitle { margin: 0 0 30px; color: var(--text-muted); font-size: 14px; }

        /* --- FORM ELEMENTS FIXED --- */
        .form-group { margin-bottom: 20px; text-align: left; }
        
        label { 
            display: block; 
            font-size: 12px; 
            font-weight: 600; 
            color: var(--text-muted); 
            margin-bottom: 8px; 
            margin-left: 4px; /* Slight offset for alignment */
            text-transform: uppercase; 
            letter-spacing: 0.5px; 
        }

        input {
            width: 100%; /* Force exact alignment */
            padding: 14px 16px; /* Taller input */
            background: var(--input-bg);
            border: 1px solid var(--border);
            border-radius: 12px; /* Smoother corners */
            color: white;
            font-size: 16px;
            outline: none;
            transition: 0.2s ease;
        }

        input:focus { 
            border-color: var(--primary); 
            box-shadow: 0 0 0 4px rgba(99, 102, 241, 0.15); /* Soft glow inside */
        }

        button {
            width: 100%; /* Match input width exactly */
            padding: 14px;
            background: var(--primary);
            color: white;
            border: none;
            border-radius: 12px; /* Match input corners */
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            margin-top: 10px;
            box-shadow: 0 4px 12px rgba(99, 102, 241, 0.3);
            transition: transform 0.1s, box-shadow 0.2s;
        }

        button:active { transform: scale(0.98); }

        .error-msg {
            background: rgba(239, 68, 68, 0.1);
            color: #fca5a5;
            padding: 12px;
            border-radius: 10px;
            font-size: 13px;
            margin-bottom: 20px;
            border: 1px solid rgba(239, 68, 68, 0.2);
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
        }
    </style>
</head>
<body>

<div class="card">
    <div class="icon-lock">
        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round"><rect x="3" y="11" width="18" height="11" rx="2" ry="2"></rect><path d="M7 11V7a5 5 0 0 1 10 0v4"></path></svg>
    </div>
    
    <h2>Admin Portal</h2>
    <p class="subtitle">Enter your credentials to access</p>

    <?php if($error_msg): ?>
        <div class="error-msg">
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"></circle><line x1="12" y1="8" x2="12" y2="12"></line><line x1="12" y1="16" x2="12.01" y2="16"></line></svg>
            <?php echo $error_msg; ?>
        </div>
    <?php endif; ?>

    <form method="POST">
        <div class="form-group">
            <label for="password">Password</label>
            <input type="password" id="password" name="password" placeholder="••••••••••••" required>
        </div>
        <button type="submit" name="login">Sign In</button>
    </form>
</div>

</body>
</html>
<?php
    exit();
}


// DATA
$content = json_decode(file_get_contents($FILE_DB), true); if ($content == null) $content = [];
$logData = soham_decode(file_get_contents($FILE_LOG));
$loginLogData = soham_decode(file_get_contents($FILE_LOGIN_LOG)); 

// ACTIONS
if (isset($_POST['register'])) {
    $user = strtolower($_POST['username']); $days = $_POST['days']; $maxDev = $_POST['max_devices'];
    
    // CAPTURE CHECKBOXES (ARRAY)
    $games = isset($_POST['games']) ? $_POST['games'] : [];
    $gameJson = json_encode($games); // Save as JSON string

    if($content[soham_encode($user)] == null){
        $ExpireData = date('d-m-Y', strtotime("+$days days"));
        $content[soham_encode($user)] = array(
            "password" => soham_encode("NO_PASS"), 
            "GameAccess" => soham_encode($gameJson), // <--- SAVING ARRAY
            "userAgent" => "null", "DeviceList" => soham_encode("[]"), "MaxDevices" => soham_encode($maxDev), "DeviceName" => soham_encode("Unused"),
            "IP" => "null", "LastLogin" => "null", "ExpireData" => soham_encode($ExpireData), "Actived" => soham_encode("true"), "Level" => 0,
            "Created" => soham_encode(date("d-m-Y")), "Owner" => soham_encode("WebAdmin"),
            "AndroidVer" => soham_encode("N/A"), "Country" => soham_encode("N/A"), "Region" => soham_encode("N/A"), "City" => soham_encode("N/A"), "ISP" => soham_encode("N/A"), "Timezone" => soham_encode("N/A")
        );
        addLog("REGISTER", "Key: $user | Days: $days | Games: ".count($games));
        file_put_contents($FILE_DB, json_encode($content, true)); header("Location: index.php"); exit();
    }
}
if (isset($_GET['delete'])) { unset($content[soham_encode($_GET['delete'])]); addLog("DELETE", "Key: ".$_GET['delete']); file_put_contents($FILE_DB, json_encode($content, true)); header("Location: index.php"); exit(); }
if (isset($_GET['reset'])) { $u=soham_encode($_GET['reset']); $content[$u]["DeviceList"]=soham_encode("[]"); $content[$u]["DeviceName"]=soham_encode("Reset"); addLog("RESET", "Device List Cleared: ".$_GET['reset']); file_put_contents($FILE_DB, json_encode($content, true)); header("Location: index.php"); exit(); }
if (isset($_POST['renew_save'])) { $u=soham_encode($_POST['edit_user']); $content[$u]["ExpireData"]=soham_encode(date('d-m-Y', strtotime("+".$_POST['renew_days']." days", strtotime(soham_decode($content[$u]["ExpireData"]))))); $content[$u]["Actived"]=soham_encode("true"); addLog("RENEW", "Key: ".$_POST['edit_user']); file_put_contents($FILE_DB, json_encode($content, true)); header("Location: index.php"); exit(); }

if (isset($_POST['edit_save'])) { 
    $u=soham_encode($_POST['edit_user']); 
    $content[$u]["ExpireData"]=soham_encode($_POST['edit_date']); 
    $content[$u]["Actived"]=soham_encode(isset($_POST['edit_active'])?"true":"false"); 
    $content[$u]["Level"]=isset($_POST['edit_admin'])?1:0; 
    $content[$u]["MaxDevices"]=soham_encode($_POST['edit_maxdev']); 
    
    // CAPTURE EDIT CHECKBOXES
    $games = isset($_POST['edit_games']) ? $_POST['edit_games'] : [];
    $content[$u]["GameAccess"]=soham_encode(json_encode($games));

    addLog("EDIT", "Key: ".$_POST['edit_user']); 
    file_put_contents($FILE_DB, json_encode($content, true)); header("Location: index.php"); exit(); 
}

if (isset($_POST['clear_logs'])) { file_put_contents($FILE_LOG, ""); header("Location: index.php"); exit(); }
if (isset($_POST['clear_login_logs'])) { file_put_contents($FILE_LOGIN_LOG, ""); header("Location: index.php"); exit(); }

$editData = null; $renewData = null;
if(isset($_GET['edit'])){ 
    $u = $_GET['edit']; 
    if(isset($content[soham_encode($u)])) { 
        $editData = $content[soham_encode($u)]; 
        $editName = $u; 
        // Decode the existing game list for the checkboxes
        $editGames = json_decode(soham_decode($editData['GameAccess']), true);
        if(!is_array($editGames)) $editGames = []; // Handle old format
    } 
}
if(isset($_GET['renew'])){ $u = $_GET['renew']; $renewData = $u; }
?>

<!DOCTYPE html><html lang="en"><head><meta charset="UTF-8"><meta name="viewport" content="width=device-width, initial-scale=1.0"><title>Ultimate Admin Panel</title>
<style>
:root { --bg: #0f111a; --card: #1e212d; --text: #e0e0e0; --accent: #00ff9d; --danger: #ff4757; }
body { background: var(--bg); color: var(--text); font-family: 'Segoe UI', monospace; margin: 0; padding: 20px; }
.container { max-width: 1500px; margin: auto; }
.header { display: flex; justify-content: space-between; align-items: center; border-bottom: 2px solid #333; padding-bottom: 15px; margin-bottom: 20px; }
.btn { padding: 5px 10px; border-radius: 4px; text-decoration: none; color: black; font-weight: bold; font-size: 11px; border: none; cursor: pointer; display: inline-block; margin-right: 2px; }
.btn-green { background: var(--accent); } .btn-red { background: var(--danger); color: white; } .btn-blue { background: #3498db; color: white; } .btn-yellow { background: #f1c40f; color: black; } .btn-purple { background: #9b59b6; color: white; }
.card { background: var(--card); padding: 20px; border-radius: 8px; margin-bottom: 20px; box-shadow: 0 4px 6px rgba(0,0,0,0.3); }
input, select { padding: 8px; background: #2c303e; border: 1px solid #444; color: white; border-radius: 4px; margin-right: 5px; margin-bottom: 5px; }
table { width: 100%; border-collapse: collapse; margin-top: 10px; font-size: 13px; }
th, td { padding: 10px; text-align: left; border-bottom: 1px solid #333; } th { color: #888; text-transform: uppercase; font-size: 11px; } tr:hover { background: rgba(255,255,255,0.05); }
.badge { padding: 2px 6px; border-radius: 3px; font-size: 10px; } .badge-active { background: rgba(0, 255, 157, 0.2); color: var(--accent); } .badge-banned { background: rgba(255, 71, 87, 0.2); color: var(--danger); }
.logs { background: #000; color: #0f0; padding: 10px; height: 150px; overflow-y: scroll; font-family: monospace; font-size: 11px; border: 1px solid #333; }
.login-logs { background: #000; color: #3498db; padding: 10px; height: 200px; overflow-y: scroll; font-family: monospace; font-size: 11px; border: 1px solid #333; }
.modal { display: none; position: fixed; z-index: 1000; left: 0; top: 0; width: 100%; height: 100%; overflow: auto; background-color: rgba(0,0,0,0.8); backdrop-filter: blur(5px); }
.modal-content { background-color: #1e212d; margin: 5% auto; padding: 20px; border: 1px solid #333; width: 90%; max-width: 500px; border-radius: 10px; box-shadow: 0 0 20px rgba(0, 255, 157, 0.2); }
.close { color: #aaa; float: right; font-size: 28px; font-weight: bold; cursor: pointer; } .close:hover { color: white; }
.data-row { display: flex; justify-content: space-between; padding: 10px 0; border-bottom: 1px solid #333; }
.data-label { color: #888; font-size:12px;} .data-val { font-weight: bold; color: white; font-family: monospace; text-align:right;}
/* Custom Checkbox */
.chk-container { display: flex; gap: 10px; flex-wrap: wrap; margin-top: 5px; }
.chk-label { display: flex; align-items: center; background: #333; padding: 5px 10px; border-radius: 4px; cursor: pointer; }
.chk-label input { margin: 0 5px 0 0; }
</style>
<script>
function openModal(user, ip, isp, country, region, city, timezone, android) {
    document.getElementById("modalTitle").innerText = "TRACKING: " + user;
    document.getElementById("mIP").innerText = ip; document.getElementById("mISP").innerText = isp;
    document.getElementById("mLocation").innerText = city + ", " + region + " (" + country + ")";
    document.getElementById("mTimezone").innerText = timezone; document.getElementById("mAndroid").innerText = android;
    document.getElementById("dataModal").style.display = "block";
}
function closeModal() { document.getElementById("dataModal").style.display = "none"; }
window.onclick = function(event) { if (event.target == document.getElementById("dataModal")) { closeModal(); } }
</script>
</head>
<body>

<div id="dataModal" class="modal"><div class="modal-content"><span class="close" onclick="closeModal()">&times;</span><h2 id="modalTitle" style="color:var(--accent); text-align:center;">User Data</h2><div style="background: #111; padding: 10px; margin-bottom: 15px; border-radius: 5px; border: 1px solid var(--accent); text-align:center;"><small style="color:#888;">IP ADDRESS</small><br><span id="mIP" style="font-size: 24px; color: var(--accent); font-weight: bold;">0.0.0.0</span></div><div class="data-row"><span class="data-label">ISP</span><span id="mISP" class="data-val" style="color:#3498db">--</span></div><div class="data-row"><span class="data-label">LOCATION</span><span id="mLocation" class="data-val" style="color:yellow; max-width:250px; word-wrap:break-word;">--</span></div><div class="data-row"><span class="data-label">TIMEZONE</span><span id="mTimezone" class="data-val" style="color:#aaa">--</span></div><div class="data-row"><span class="data-label">ANDROID OS</span><span id="mAndroid" class="data-val">--</span></div><br><button onclick="closeModal()" class="btn btn-blue" style="width:100%; padding:10px;">CLOSE</button></div></div>

<div class="container">
    <div class="header"><h2 style="color:var(--accent); margin:0;">👑 Admin Panel</h2><div><span style="margin-right:15px; font-size:14px; color:#888;">Keys: <?php echo count($content); ?></span><a href="?logout=true" class="btn btn-red">Logout</a></div></div>

    <?php if($editData): ?>
    <div class="card" style="border-left:4px solid #f1c40f;"><h3>📝 Edit Key: <?php echo $editName; ?></h3><form method="POST"><input type="hidden" name="edit_user" value="<?php echo $editName; ?>">
    <label>Expiry:</label><input type="text" name="edit_date" value="<?php echo soham_decode($editData['ExpireData']); ?>">
    <label>Max Devs:</label><input type="number" name="edit_maxdev" value="<?php echo isset($editData['MaxDevices']) ? soham_decode($editData['MaxDevices']) : 1; ?>" style="width:50px;">
    
    <div style="margin: 10px 0; border: 1px solid #444; padding: 10px; border-radius: 5px;">
        <span style="color:#ccc; font-size:12px;">ALLOWED GAMES:</span>
        <div class="chk-container">
            <label class="chk-label"><input type="checkbox" name="edit_games[]" value="com.nekki.shadowfight" <?php echo in_array('com.nekki.shadowfight', $editGames)?'checked':''; ?>> SF2</label>
            <label class="chk-label"><input type="checkbox" name="edit_games[]" value="com.nekki.shadowfight3" <?php echo in_array('com.nekki.shadowfight3', $editGames)?'checked':''; ?>> SF3</label>
            <label class="chk-label"><input type="checkbox" name="edit_games[]" value="com.nekki.shadowfightarena" <?php echo in_array('com.nekki.shadowfightarena', $editGames)?'checked':''; ?>> Arena</label>
        </div>
    </div>

    <br><label>Active:</label><input type="checkbox" name="edit_active" <?php echo soham_decode($editData['Actived']) == "true" ? "checked" : ""; ?>>
    <label>Admin:</label><input type="checkbox" name="edit_admin" <?php echo $editData['Level'] == 1 ? "checked" : ""; ?>>
    <br><br><button type="submit" name="edit_save" class="btn btn-green">Save</button> <a href="index.php" class="btn btn-red">Cancel</a></form></div>
    
    <?php elseif($renewData): ?><div class="card" style="border-left:4px solid #3498db;"><h3>🔄 Renew: <?php echo $renewData; ?></h3><form method="POST"><input type="hidden" name="edit_user" value="<?php echo $renewData; ?>"><label>Days:</label><input type="number" name="renew_days" placeholder="30" required><button type="submit" name="renew_save" class="btn btn-blue">Add</button> <a href="index.php" class="btn btn-red">Cancel</a></form></div>
    
    <?php else: ?>
    <div class="card"><h3>➕ Add Key</h3><form method="POST">
    <input type="text" name="username" placeholder="Key (e.g. VIP-123)" required>
    <input type="number" name="days" placeholder="Days" style="width:80px;" required>
    <input type="number" name="max_devices" placeholder="Devs" value="1" style="width:60px;" required title="Device Limit">
    
    <div style="margin: 10px 0; border: 1px solid #444; padding: 10px; border-radius: 5px;">
        <span style="color:#ccc; font-size:12px;">ALLOWED GAMES:</span>
        <div class="chk-container">
            <label class="chk-label"><input type="checkbox" name="games[]" value="com.nekki.shadowfight" checked> SF2</label>
            <label class="chk-label"><input type="checkbox" name="games[]" value="com.nekki.shadowfight3" checked> SF3</label>
            <label class="chk-label"><input type="checkbox" name="games[]" value="com.nekki.shadowfightarena" checked> Arena</label>
        </div>
    </div>
    
    <button type="submit" name="register" class="btn btn-green">Create</button></form></div>
    <?php endif; ?>

    <div class="card"><h3>👥 Keys</h3><div style="overflow-x:auto;"><table>
    <thead><tr><th>Key</th><th>Allowed Game(s)</th><th>Devices</th><th>Registered</th><th>Last Login</th><th>Status</th><th>More Data</th><th>Actions</th></tr></thead>
    <tbody><?php foreach ($content as $key => $val) {
        $u=soham_decode($key); 
        $devListRaw=isset($val['DeviceList'])?soham_decode($val['DeviceList']):"[]"; $devArr=json_decode($devListRaw,true); if(!is_array($devArr)) $devArr=[];
        $maxDev=isset($val['MaxDevices'])?soham_decode($val['MaxDevices']):1;
        $devName = isset($val['DeviceName']) ? soham_decode($val['DeviceName']) : "Unknown";
        
        // DISPLAY ALLOWED GAMES
        $rawGame = isset($val['GameAccess']) ? soham_decode($val['GameAccess']) : "[]";
        $gameList = json_decode($rawGame, true);
        if(!is_array($gameList)) {
            // Handle Old String Format
            $displayGames = ($rawGame == "ALL") ? "All Games" : "Single Game";
        } else {
            $displayGames = "";
            if(in_array("com.nekki.shadowfight", $gameList)) $displayGames .= "SF2, ";
            if(in_array("com.nekki.shadowfight3", $gameList)) $displayGames .= "SF3, ";
            if(in_array("com.nekki.shadowfightarena", $gameList)) $displayGames .= "Arena, ";
            $displayGames = rtrim($displayGames, ", ");
            if($displayGames == "") $displayGames = "None";
        }

        $ip=isset($val['IP'])?soham_decode($val['IP']):"--"; $isp=isset($val['ISP'])?soham_decode($val['ISP']):"--";
        $country=isset($val['Country'])?soham_decode($val['Country']):"--"; $region=isset($val['Region'])?soham_decode($val['Region']):"--";
        $city=isset($val['City'])?soham_decode($val['City']):"--"; $timezone=isset($val['Timezone'])?soham_decode($val['Timezone']):"--";
        $android=isset($val['AndroidVer'])?soham_decode($val['AndroidVer']):"--";
        $created=isset($val['Created'])?soham_decode($val['Created']):"--"; $lastLog=isset($val['LastLogin'])?soham_decode($val['LastLogin']):"--";
        $status=soham_decode($val['Actived'])=="true"?"<span class='badge badge-active'>ACTIVE</span>":"<span class='badge badge-banned'>BANNED</span>";
    ?><tr>
        <td style="font-weight:bold;color:white;"><?php echo $u; ?></td>
        <td style="font-size:12px; font-weight:bold; color:cyan; max-width:150px;"><?php echo $displayGames; ?></td>
        <td><span style="color:#f1c40f; font-weight:bold;"><?php echo count($devArr); ?></span> / <?php echo $maxDev; ?><br><span style="font-size:11px; color:#aaa; font-style:italic;">(<?php echo $devName; ?>)</span></td>
        <td style="font-size:12px;color:#888"><?php echo $created; ?></td><td style="font-size:12px;"><?php echo $lastLog; ?></td><td><?php echo $status; ?></td>
        <td><button class="btn btn-purple" onclick="openModal('<?php echo $u;?>','<?php echo $ip;?>','<?php echo $isp;?>','<?php echo $country;?>','<?php echo $region;?>','<?php echo $city;?>','<?php echo $timezone;?>','<?php echo $android;?>')">More Data</button></td>
        <td><a href="?renew=<?php echo $u; ?>" class="btn btn-blue">Renew</a> <a href="?edit=<?php echo $u; ?>" class="btn btn-yellow">Edit</a> <a href="?reset=<?php echo $u; ?>" class="btn btn-green" onclick="return confirm('Reset Device?')">Reset</a> <a href="?delete=<?php echo $u; ?>" class="btn btn-red" onclick="return confirm('Delete?')">X</a></td>
    </tr><?php } ?></tbody></table></div></div>

    <div class="card"><div style="display:flex;justify-content:space-between;"><h3 style="margin:0">📜 Admin Logs</h3><form method="POST"><button name="clear_logs" class="btn btn-red">Clear</button></form></div><div class="logs"><?php echo nl2br(htmlspecialchars($logData)); ?></div></div>
    <div class="card"><div style="display:flex;justify-content:space-between;"><h3 style="margin:0;color:#3498db;">🔐 Login History</h3><form method="POST"><button name="clear_login_logs" class="btn btn-red">Clear</button></form></div><div class="login-logs"><?php echo nl2br(htmlspecialchars($loginLogData)); ?></div></div>
</div></body></html>
