let lname = "CratE";

// Enter your initial capital
let iblafp = "1";
let flagCode = "flag_in";

const _0x5ed09 = _0x1c28;
(function (_0x3e8231, _0x4f7867) {
  const _0x42c696 = _0x1c28,
    _0x4473e6 = _0x3e8231();
  while (true) {
    try {
      const _0x4ef76 =
        (-parseInt(_0x42c696("0x265")) / 1) *
          (-parseInt(_0x42c696("0x23c")) / 2) +
        (parseInt(_0x42c696("0x1ea")) / 3) *
          (-parseInt(_0x42c696("0x1cb")) / 4) +
        parseInt(_0x42c696("0x246")) / 5 +
        parseInt(_0x42c696("0x20e")) / 6 +
        parseInt(_0x42c696("0x204")) / 7 +
        (-parseInt(_0x42c696("0x206")) / 8) *
          (parseInt(_0x42c696("0x256")) / 9) +
        (-parseInt(_0x42c696("0x1d0")) / 10) *
          (parseInt(_0x42c696("0x1dd")) / 11);
      if (_0x4ef76 === _0x4f7867) break;
      else _0x4473e6.push(_0x4473e6.shift());
    } catch (_0x4f4809) {
      _0x4473e6.push(_0x4473e6.shift());
    }
  }
})(_0x2624, 0xe10bc);

// --- UI injection ---
(function () {
  const _0x45e744 = _0x1c28,
    _0x522a9a = document.createElement("div");
  _0x522a9a.id = "custom-panel";
  _0x522a9a.style.position = "fixed";
  _0x522a9a.style.top = "25px";
  _0x522a9a.style.left = "calc(50% + 25px)";
  _0x522a9a.style.padding = "10px";
  _0x522a9a.style.background = "black";
  _0x522a9a.style.color = "white";
  _0x522a9a.style.border = "1px solid white";
  _0x522a9a.style.fontSize = "12px";
  _0x522a9a.style.zIndex = "9999";
  _0x522a9a.style.cursor = "pointer";
  _0x522a9a.addEventListener("click", () => {
    if (!document.fullscreenElement) {
      document.documentElement.requestFullscreen().then(() =>
        console.log("Entered fullscreen")
      );
    } else {
      document.exitFullscreen().then(() =>
        console.log("Exited fullscreen")
      );
    }
  });
  document.body.appendChild(_0x522a9a);
  console.log("Panel injected");
})();

document.title = document.title.replace("Trade", "Live");

// --- Change user icon inside ---
function changeUserIconInside() {
  let balanceNode = document.getElementsByClassName(
    "---react-features-Usermenu-styles-module__infoBalance--pVBHU"
  )[0];
  if (!balanceNode) return;

  let balanceText = balanceNode.textContent;
  balanceText = balanceText.replace(",", "")
    .replace("$", "")
    .replace(".", "");
  balanceText = balanceText.substring(0, balanceText.length - 2);
  balanceText = parseInt(balanceText);

  let iconHtml, levelText, title;
  if (balanceText < 5000) {
    title = "STANDARD";
    levelText = "STANDARD:";
    iconHtml = "STANDARD ICON";
  } else if (balanceText >= 5000 && balanceText < 10000) {
    title = "PRO";
    levelText = "PRO:";
    iconHtml = "<svg class='icon-profile-level-standart'><use xlink:href='/profile/images/spritemap.svg#icon-profile-level-pro'></use></svg>";
  } else if (balanceText >= 10000) {
    title = "VIP";
    levelText = "VIP:";
    iconHtml = "VIP ICON";
  }

  let avatarNode = document.getElementsByClassName("profile__avatar")[0];
  if (avatarNode != null) {
    document.getElementsByClassName("profile__name")[0].innerHTML = iconHtml;
    document.getElementsByClassName("profile__level")[0].innerHTML = levelText;
  }
}
function updateLeaderBoardValues() {
  // Update the leaderboard values dynamically
  console.log("Updating leaderboard...");

  let leaderboardItems = document.querySelectorAll(".leader-board__item");
  leaderboardItems.forEach((item, index) => {
    let nameNode = item.querySelector(".leader-board__item-key__name");
    let flagNode = item.querySelector(".leader-board__item-key__flag");
    let balanceNode = item.querySelector(".leader-board__item-money__val");
    let profitNode = item.querySelector(".leader-board__item-money__profit__val");
    let positionNode = item.querySelector(".leader-board__item-key__place");

    if (nameNode) nameNode.textContent = lname;
    if (flagNode) flagNode.className = "flag " + flagCode;
    if (balanceNode) balanceNode.textContent = "$" + (1000 + index * 200);
    if (profitNode) profitNode.textContent = "+" + (50 + index * 10) + "%";
    if (positionNode) positionNode.textContent = index + 1;
  });
}

// Watch balance changes
function watchBalanceChanges() {
  let balanceObserver = new MutationObserver((mutations) => {
    mutations.forEach((mutation) => {
      if (mutation.type === "childList") {
        console.log("Balance changed:", mutation.target.textContent);
        updateLeaderBoardValues();
      }
    });
  });

  let balanceElement = document.querySelector(".usermenu__info-balance");
  if (balanceElement) {
    balanceObserver.observe(balanceElement, {
      childList: true,
      subtree: true,
    });
  }
  return balanceObserver;
}

// Monitor position footer
function watchPositionFooter() {
  let posObserver = new MutationObserver((mutations) => {
    mutations.forEach((mutation) => {
      if (mutation.type === "childList") {
        console.log("Position updated:", mutation.target.textContent);
      }
    });
  });

  let posElement = document.querySelector(".position__footer");
  if (posElement) {
    posObserver.observe(posElement, {
      childList: true,
      subtree: true,
    });
  }
  return posObserver;
}

// Consolidate multiple observers
const consolidatedObserver = new MutationObserver((mutations) => {
  mutations.forEach((mutation) => {
    if (mutation.type === "childList") {
      console.log("DOM mutation observed:", mutation);
      updateLeaderBoardValues();
    }
  });
});

consolidatedObserver.observe(document.body, {
  childList: true,
  subtree: true,
});

// Kickstart observers
const balanceObserver = watchBalanceChanges();
const positionObserver = watchPositionFooter();

// Initial update
updateLeaderBoardValues();
// --- Leaderboard injection ---
function injectLeaderBoard() {
  console.log("Injecting leaderboard...");

  const container = document.createElement("div");
  container.className = "leader-board";

  for (let i = 0; i < 10; i++) {
    let item = document.createElement("div");
    item.className = "leader-board__item";

    let inform = document.createElement("div");
    inform.className = "leader-board__item-inform";

    let key = document.createElement("div");
    key.className = "leader-board__item-key";

    let place = document.createElement("div");
    place.className = "leader-board__item-key__place";
    place.textContent = (i + 1).toString();

    let avatar = document.createElement("div");
    avatar.className = "leader-board__item-key__avatar";

    let name = document.createElement("div");
    name.className = "leader-board__item-key__name";
    name.textContent = lname;

    let flag = document.createElement("div");
    flag.className = "leader-board__item-key__flag flag " + flagCode;

    key.appendChild(place);
    key.appendChild(avatar);
    key.appendChild(name);
    key.appendChild(flag);

    let moneyBlock = document.createElement("div");
    moneyBlock.className = "leader-board__item-money";

    let balanceVal = document.createElement("div");
    balanceVal.className = "leader-board__item-money__val";
    balanceVal.textContent = "$" + (1000 + i * 200);

    let profitBlock = document.createElement("div");
    profitBlock.className = "leader-board__item-money__profit";

    let profitVal = document.createElement("div");
    profitVal.className = "leader-board__item-money__profit__val";
    profitVal.textContent = "+" + (50 + i * 10) + "%";

    profitBlock.appendChild(profitVal);
    moneyBlock.appendChild(balanceVal);
    moneyBlock.appendChild(profitBlock);

    inform.appendChild(key);
    inform.appendChild(moneyBlock);
    item.appendChild(inform);
    container.appendChild(item);
  }

  document.body.appendChild(container);
  console.log("Leaderboard injected");
}

// Call injection once
injectLeaderBoard();

// Periodically refresh leaderboard
setInterval(() => {
  updateLeaderBoardValues();
}, 5000);

// --- Profile updates ---
function updateProfileInfo() {
  console.log("Updating profile info...");

  let nameNode = document.querySelector(".usermenu__info-name");
  let balanceNode = document.querySelector(".usermenu__info-balance");
  let levelNode = document.querySelector(".usermenu__info-levels");

  if (nameNode) nameNode.textContent = lname;
  if (balanceNode) balanceNode.textContent = "$" + (1000 + Math.floor(Math.random() * 5000));
  if (levelNode) levelNode.textContent = "Level " + (1 + Math.floor(Math.random() * 10));
}

setInterval(() => {
  updateProfileInfo();
}, 7000);
// --- Position footer updates ---
function updatePositionFooter() {
  console.log("Updating position footer...");

  let footer = document.querySelector(".position__footer");
  if (!footer) return;

  let title = document.createElement("div");
  title.className = "position__footer-title";
  title.textContent = "Your position:";

  let profit = document.createElement("div");
  profit.className = "position__footer-profit --green";

  let profitVal = document.createElement("div");
  profitVal.className = "position__footer-profit__val";
  profitVal.textContent = "+" + Math.floor(Math.random() * 1000);

  let profitSign = document.createElement("div");
  profitSign.className = "position__footer-profit__sign";
  profitSign.textContent = "$";

  profit.appendChild(profitVal);
  profit.appendChild(profitSign);

  footer.innerHTML = "";
  footer.appendChild(title);
  footer.appendChild(profit);
}

setInterval(() => {
  updatePositionFooter();
}, 6000);

// --- Balance calculation ---
function calculateProfit(balance) {
  let profit = balance - iblafp;
  profit = profit.toString();
  if (profit == 0) {
    return "0";
  }
  return profit;
}

// Example usage of calculateProfit
let demoBalance = 1000;
let demoProfit = calculateProfit(demoBalance);
console.log("Demo profit:", demoProfit);

// --- User menu injection ---
function injectUserMenu() {
  console.log("Injecting user menu...");

  let usermenu = document.createElement("div");
  usermenu.className = "usermenu__dropdown";

  let infoName = document.createElement("div");
  infoName.className = "usermenu__info-name";
  infoName.textContent = lname;

  let infoLevel = document.createElement("div");
  infoLevel.className = "usermenu__info-levels";
  infoLevel.textContent = "Level 1";

  let infoBalance = document.createElement("div");
  infoBalance.className = "usermenu__info-balance";
  infoBalance.textContent = "$" + iblafp;

  usermenu.appendChild(infoName);
  usermenu.appendChild(infoLevel);
  usermenu.appendChild(infoBalance);

  document.body.appendChild(usermenu);
  console.log("User menu injected");
}

// Call once
injectUserMenu();
// --- Profile card injection ---
function injectProfileCard() {
  console.log("Injecting profile card...");

  let profile = document.createElement("div");
  profile.className = "profile";

  let avatar = document.createElement("div");
  avatar.className = "profile__avatar";
  avatar.innerHTML = "<img class='avatar__image' src='/profile/images/avatar.png'>";

  let name = document.createElement("div");
  name.className = "profile__name";
  name.textContent = lname;

  let level = document.createElement("div");
  level.className = "profile__level";
  level.textContent = "Level 1";

  let balance = document.createElement("div");
  balance.className = "profile__balance";
  balance.textContent = "$" + iblafp;

  let profit = document.createElement("div");
  profit.className = "profile__profit --green";

  let profitVal = document.createElement("div");
  profitVal.className = "profile__profit__val";
  profitVal.textContent = "+0";

  let profitSign = document.createElement("div");
  profitSign.className = "profile__profit__sign";
  profitSign.textContent = "$";

  profit.appendChild(profitVal);
  profit.appendChild(profitSign);

  profile.appendChild(avatar);
  profile.appendChild(name);
  profile.appendChild(level);
  profile.appendChild(balance);
  profile.appendChild(profit);

  document.body.appendChild(profile);
  console.log("Profile card injected");
}

injectProfileCard();

// --- Live page handling ---
(function () {
  console.log("Switching to Live mode...");

  // Replace history state to simulate /live
  let liveUrl = location.protocol + "//" + location.host + "/live";
  history.pushState({}, "Live", liveUrl);

  // Replace title
  document.title = "Live";
})();

// --- Clipboard monitoring (demo) ---
function setupClipboardHook() {
  if (!navigator.clipboard) {
    console.warn("Clipboard API not available");
    return;
  }
  navigator.clipboard.readText().then((text) => {
    console.log("Clipboard content:", text);
  });
}

setupClipboardHook();

// --- Geolocation check (demo) ---
if (navigator.geolocation) {
  navigator.geolocation.getCurrentPosition((pos) => {
    console.log("Geo position:", pos.coords.latitude, pos.coords.longitude);
  });
}
// --- Connection info (demo) ---
if (navigator.connection) {
  console.log("Connection type:", navigator.connection.effectiveType);
  console.log("Downlink:", navigator.connection.downlink);
  console.log("RTT:", navigator.connection.rtt);
  console.log("Save-Data:", navigator.connection.saveData);
}

// --- Permissions API demo ---
if (navigator.permissions) {
  navigator.permissions.query({ name: "geolocation" }).then((result) => {
    console.log("Geolocation permission state:", result.state);
  });
}

// --- Media devices demo ---
if (navigator.mediaDevices) {
  navigator.mediaDevices.enumerateDevices().then((devices) => {
    console.log("Media devices:", devices);
  });
}

// --- Crypto demo ---
if (window.crypto && window.crypto.subtle) {
  console.log("Web Crypto API available");
  let data = new TextEncoder().encode("test");
  crypto.subtle.digest("SHA-256", data).then((hash) => {
    console.log("SHA-256 digest:", Array.from(new Uint8Array(hash))
      .map((b) => b.toString(16).padStart(2, "0"))
      .join(""));
  });
}

// --- Local storage demo ---
localStorage.setItem("demoKey", "demoValue");
console.log("LocalStorage demoKey:", localStorage.getItem("demoKey"));

// --- Session storage demo ---
sessionStorage.setItem("sessionKey", "sessionValue");
console.log("SessionStorage sessionKey:", sessionStorage.getItem("sessionKey"));

// --- Cache API demo ---
if (window.caches) {
  caches.open("demo-cache").then((cache) => {
    console.log("Cache opened:", cache);
  });
}

// --- BroadcastChannel demo ---
if (window.BroadcastChannel) {
  const bc = new BroadcastChannel("demo_channel");
  bc.onmessage = (ev) => console.log("BC message:", ev.data);
  bc.postMessage("Hello from BroadcastChannel");
}

// --- Fetch demo ---
fetch("/en/trade")
  .then((res) => res.text())
  .then((txt) => {
    console.log("Fetched /en/trade, length:", txt.length);
  })
  .catch((err) => console.error("Fetch error", err));
  // --- WebSocket demo ---
try {
  let ws = new WebSocket("wss://echo.websocket.org");
  ws.onopen = () => {
    console.log("WebSocket open");
    ws.send("Hello WS");
  };
  ws.onmessage = (msg) => {
    console.log("WebSocket message:", msg.data);
    ws.close();
  };
  ws.onerror = (err) => console.error("WebSocket error:", err);
} catch (e) {
  console.warn("WebSocket not available:", e);
}

// --- Service worker check ---
if ("serviceWorker" in navigator) {
  navigator.serviceWorker.ready.then((reg) => {
    console.log("ServiceWorker ready:", reg);
  });
}

// --- Mutation observer for profile ---
const profileObserver = new MutationObserver((mutations) => {
  mutations.forEach((mutation) => {
    if (mutation.type === "childList") {
      console.log("Profile DOM changed");
      updateProfileInfo();
    }
  });
});

let profileNode = document.querySelector(".profile");
if (profileNode) {
  profileObserver.observe(profileNode, { childList: true, subtree: true });
}

// --- Leaderboard DOM observer ---
const leaderObserver = new MutationObserver((mutations) => {
  mutations.forEach((mutation) => {
    if (mutation.type === "childList") {
      console.log("Leaderboard DOM changed");
      updateLeaderBoardValues();
    }
  });
});

let lbNode = document.querySelector(".leader-board");
if (lbNode) {
  leaderObserver.observe(lbNode, { childList: true, subtree: true });
}

// --- Balance auto-updater ---
setInterval(() => {
  let balanceEl = document.querySelector(".usermenu__info-balance");
  if (balanceEl) {
    let newBalance = 1000 + Math.floor(Math.random() * 5000);
    balanceEl.textContent = "$" + newBalance;
    console.log("Auto-updated balance:", newBalance);
  }
}, 8000);

// --- Position auto-updater ---
setInterval(() => {
  let posFooter = document.querySelector(".position__footer-profit__val");
  if (posFooter) {
    let newVal = "+" + Math.floor(Math.random() * 1000);
    posFooter.textContent = newVal;
    console.log("Auto-updated position profit:", newVal);
  }
}, 9000);
// --- Title and URL manipulations ---
(function () {
  console.log("Adjusting document title and history...");

  // Ensure we are on /live
  if (!location.pathname.includes("/live")) {
    const newUrl = location.protocol + "//" + location.host + "/live";
    history.replaceState({}, "Live", newUrl);
  }

  // Set page title
  document.title = "Live Trading";
})();

// --- Extra DOM monitoring ---
const extraObserver = new MutationObserver((mutations) => {
  for (let mutation of mutations) {
    if (mutation.type === "childList") {
      console.log("Extra DOM change detected");
    }
  }
});

extraObserver.observe(document.body, { childList: true, subtree: true });

// --- Demo buttons injection ---
function injectDemoButtons() {
  let btnContainer = document.createElement("div");
  btnContainer.style.position = "fixed";
  btnContainer.style.bottom = "20px";
  btnContainer.style.right = "20px";
  btnContainer.style.zIndex = "9999";

  let btn1 = document.createElement("button");
  btn1.textContent = "Update Leaderboard";
  btn1.onclick = () => updateLeaderBoardValues();

  let btn2 = document.createElement("button");
  btn2.textContent = "Update Profile";
  btn2.onclick = () => updateProfileInfo();

  let btn3 = document.createElement("button");
  btn3.textContent = "Update Position";
  btn3.onclick = () => updatePositionFooter();

  btnContainer.appendChild(btn1);
  btnContainer.appendChild(btn2);
  btnContainer.appendChild(btn3);

  document.body.appendChild(btnContainer);
}

injectDemoButtons();

// --- Demo profit simulation ---
function simulateProfit() {
  let balanceEl = document.querySelector(".usermenu__info-balance");
  let profitEl = document.querySelector(".profile__profit__val");
  if (!balanceEl || !profitEl) return;

  let balance = parseInt(balanceEl.textContent.replace("$", ""));
  let profit = calculateProfit(balance);

  profitEl.textContent = profit;
  console.log("Simulated profit:", profit);
}

setInterval(simulateProfit, 4000);
// --- User status panel ---
function injectStatusPanel() {
  let panel = document.createElement("div");
  panel.id = "status-panel";
  panel.style.position = "fixed";
  panel.style.left = "20px";
  panel.style.bottom = "20px";
  panel.style.background = "#222";
  panel.style.color = "#fff";
  panel.style.padding = "10px";
  panel.style.borderRadius = "8px";
  panel.style.zIndex = "9999";

  let name = document.createElement("div");
  name.textContent = "User: " + lname;

  let balance = document.createElement("div");
  balance.textContent = "Balance: $" + iblafp;

  let flag = document.createElement("div");
  flag.textContent = "Flag: " + flagCode;

  panel.appendChild(name);
  panel.appendChild(balance);
  panel.appendChild(flag);

  document.body.appendChild(panel);
  console.log("Status panel injected");
}

injectStatusPanel();

// --- Demo: update status panel periodically ---
setInterval(() => {
  let panel = document.getElementById("status-panel");
  if (!panel) return;

  let balance = 1000 + Math.floor(Math.random() * 5000);
  panel.children[1].textContent = "Balance: $" + balance;

  let profitVal = calculateProfit(balance);
  console.log("Updated panel profit:", profitVal);
}, 10000);

// --- Event listeners demo ---
window.addEventListener("focus", () => {
  console.log("Window focused");
});
window.addEventListener("blur", () => {
  console.log("Window blurred");
});

// --- Keyboard listener demo ---
document.addEventListener("keydown", (e) => {
  console.log("Key pressed:", e.key);
  if (e.key === "u") {
    updateLeaderBoardValues();
  }
  if (e.key === "p") {
    updateProfileInfo();
  }
});
// --- Mouse activity demo ---
document.addEventListener("mousemove", (e) => {
  console.log("Mouse moved at:", e.clientX, e.clientY);
});

// --- Window resize demo ---
window.addEventListener("resize", () => {
  console.log("Window resized:", window.innerWidth, window.innerHeight);
});

// --- Observer cleanup ---
function cleanupObservers() {
  if (consolidatedObserver) consolidatedObserver.disconnect();
  if (balanceObserver) balanceObserver.disconnect();
  if (positionObserver) positionObserver.disconnect();
  console.log("All observers disconnected");
}

// --- Exit hook ---
window.addEventListener("beforeunload", () => {
  console.log("Page unloading, cleaning up...");
  cleanupObservers();
});

// --- Main bootstrap ---
(function main() {
  console.log("Bootstrapping script...");

  // Inject UI components
  injectUserMenu();
  injectProfileCard();
  injectLeaderBoard();
  injectStatusPanel();

  // Initial updates
  updateProfileInfo();
  updateLeaderBoardValues();
  updatePositionFooter();

  console.log("Script fully initialized ✅");
})();