<?php
session_start();

// --- 1. NEW: LOGIN CONFIGURATION ---
// SET YOUR ADMIN PASSWORD HERE
define('LOGIN_PASSWORD', '4252');

$is_logged_in = (isset($_SESSION['loggedin']) && $_SESSION['loggedin'] === true);
$error_message = '';

// Handle Logout
if (isset($_GET['logout'])) {
    session_destroy();
    header("Location: admin.php"); // Redirect to login page
    exit;
}

// Handle Login Attempt
if (isset($_POST['password'])) {
    if ($_POST['password'] === LOGIN_PASSWORD) {
        $_SESSION['loggedin'] = true;
        header("Location: index.php"); // Redirect to admin panel
        exit;
    } else {
        $error_message = 'Invalid password.';
    }
}

// If not logged in, show login form and stop.
if (!$is_logged_in) {
?>
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Admin Login</title>
        <style>
            body { font-family: Arial, sans-serif; background-color: #121212; color: #e0e0e0; display: flex; align-items: center; justify-content: center; height: 100vh; margin: 0; }
            form { background: #1e1e1e; padding: 30px; border-radius: 8px; box-shadow: 0 4px 12px rgba(0,0,0,0.5); text-align: center; }
            h2 { color: #4CAF50; margin-top: 0; }
            input[type="password"] { background: #333; color: #fff; border: 1px solid #555; padding: 10px; border-radius: 5px; width: 250px; }
            button { cursor: pointer; background: #4CAF50; color: #fff; font-weight: bold; border: none; padding: 10px 20px; border-radius: 5px; margin-top: 15px; }
            button:hover { background: #45a049; }
            p { color: #f44336; }
        </style>
    </head>
    <body>
        <form method="POST">
            <h2>👑 Admin Panel Login</h2>
            <input type="password" name="password" placeholder="Enter Password" required>
            <br>
            <button type="submit">Login</button>
            <?php if ($error_message): ?>
                <p><?php echo $error_message; ?></p>
            <?php endif; ?>
        </form>
    </body>
    </html>
<?php
    exit; // Stop the rest of the script from running
}
// --- END OF LOGIN LOGIC ---


// --- IF LOGGED IN, CONTINUE TO ADMIN PANEL ---

// --- CONFIGURATION ---
$KEYS = [
    "Key1" => "DowrDnASKiDdJFxXPxEDcjf42BUqHzkbUaCNm4wHw8AyTpa7gEGEybswr6G3JgE3paHkZbTapcWZbe4NHD",
    "Key2" => "DowrDnASKih9PAqJ6BWCSeqqns",
    "Key3" => "DowrDnASKiBPg3J6H8t6xnPVrR",
    "Sec1" => "DowrDnASKiMqJtMaxtNGV0RWp1RWtaRWJ4RWp4RWVdNHZcNWFtNGV2RWN1RWF2RWFaRWF1RWF2RWB0",
    "Sec2" => "DowrDnASKiMAgiCYHsMiwHHwbnV27Jvs4"
];
$BASE_URL = "https://miefaucet.xyz/soham/";
$GAME_CONFIGS = [
    "sf2" => ["name" => "Shadow Fight 2", "RegisterURL" => $BASE_URL . "Register.php", "UserUrl" => $BASE_URL . "User.php", "Action" => $BASE_URL . "ActionManager.php", "Log" => $BASE_URL . "Log.php"],
    "sf3" => ["name" => "Shadow Fight 3", "RegisterURL" => $BASE_URL . "Register1.php", "UserUrl" => $BASE_URL . "User1.php", "Action" => $BASE_URL . "ActionManager1.php", "Log" => $BASE_URL . "Log1.php"],
    "sfa" => ["name" => "Shadow Fight Arena", "RegisterURL" => $BASE_URL . "Register2.php", "UserUrl" => $BASE_URL . "User2.php", "Action" => $BASE_URL . "ActionManager2.php", "Log" => $BASE_URL . "Log2.php"]
];

// --- HELPER FUNCTION: Replicates gg.makeRequest ---
function makeRequest($url, $dataArray) {
    global $KEYS;
    if (!isset($dataArray['KEY']) && !isset($dataArray['Key'])) {
        $dataArray['Authorization'] = $KEYS['Key1'];
        $dataArray['Secret'] = $KEYS['Sec1'];
    }
    $jsonData = json_encode($dataArray);
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json', 'Content-Length: ' . strlen($jsonData)]);
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    if ($http_code != 200 || $response === false) {
        return "Error: Failed to connect to backend. HTTP Code: " . $http_code;
    }
    return $response; 
}

// --- LOGIC: HANDLE FORM SUBMISSIONS ---
$action_response = "";
$current_game_config = null;
$users_list = [];

if (isset($_POST['select_game'])) {
    $game_key = $_POST['game'];
    if (isset($GAME_CONFIGS[$game_key])) { $_SESSION['game'] = $game_key; }
}
if (isset($_SESSION['game']) && isset($GAME_CONFIGS[$_SESSION['game']])) {
    $current_game_config = $GAME_CONFIGS[$_SESSION['game']];
}

if ($current_game_config && isset($_POST['action'])) {
    $action = $_POST['action'];
    switch ($action) {
        case 'register':
            $payload = ["Username" => $_POST['username'], "Password" => $_POST['password'], "ConfirmPassword" => $_POST['password'], "Expiration" => $_POST['days'], "Key" => $KEYS['Key2'], "Secret" => $KEYS['Sec1'], "Level" => "0"];
            $action_response = makeRequest($current_game_config['RegisterURL'], $payload);
            break;
        case 'delete':
            $payload = ["Action" => "Delete", "Username" => $_POST['username']];
            $action_response = makeRequest($current_game_config['Action'], $payload);
            break;
        case 'reset':
            $payload = ["Action" => "Reset", "Username" => $_POST['username']];
            $action_response = makeRequest($current_game_config['Action'], $payload);
            break;
        case 'renew':
            $payload = ["Action" => "Renovate", "Username" => $_POST['username'], "Expire" => $_POST['days']];
            $action_response = makeRequest($current_game_config['Action'], $payload);
            break;
        case 'edit':
            $payload = ["Action" => "Edit", "Username" => $_POST['username'], "date" => $_POST['expire_date'], "password" => $_POST['password'], "actived" => isset($_POST['active']) ? 'true' : 'false', "level" => isset($_POST['admin']) ? 'true' : 'false'];
            $action_response = makeRequest($current_game_config['Action'], $payload);
            break;
        case 'view_log':
            $payload = ["Secret" => $KEYS['Sec1']];
            $action_response = makeRequest($current_game_config['Log'], $payload);
            break;
        case 'delete_log':
            $payload = ["Secret" => $KEYS['Sec1'], "Delete" => "true"];
            $action_response = makeRequest($current_game_config['Log'], $payload);
            break;
    }
}

if ($current_game_config) {
    $payload = ["KEY" => $KEYS['Key3'], "Secret" => $KEYS['Sec2']];
    $response = makeRequest($current_game_config['UserUrl'], $payload);
    if (strpos($response, "Error:") === false) {
        $lines = explode("\\n", $response);
        foreach ($lines as $line) {
            if (trim($line) == "") continue;
            $parts = explode("||", $line);
            if (count($parts) >= 8) {
                $users_list[] = ["Name" => $parts[0], "Password" => $parts[1], "Expire" => $parts[2], "Active" => $parts[3], "LastLogin" => $parts[4], "Owner" => $parts[5], "Created" => $parts[6], "Admin" => $parts[7]];
            }
        }
    } else {
        $action_response = $response;
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SohaM Admin Panel</title>
    <style>
        body { font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif; background-color: #121212; color: #e0e0e0; margin: 0; padding: 20px; }
        .container { max-width: 1200px; margin: auto; background: #1e1e1e; padding: 20px; border-radius: 8px; box-shadow: 0 4px 12px rgba(0,0,0,0.5); }
        h1, h2 { color: #4CAF50; border-bottom: 2px solid #4CAF50; padding-bottom: 10px; }
        select, input[type="text"], input[type="password"], input[type="number"], button { background: #333; color: #fff; border: 1px solid #555; padding: 10px; border-radius: 5px; margin: 5px 0; box-sizing: border-box; }
        button { cursor: pointer; background: #4CAF50; font-weight: bold; border-color: #4CAF50; }
        button:hover { background: #45a049; }
        .btn-danger { background: #f44336; border-color: #f44336; }
        .btn-danger:hover { background: #da190b; }
        .btn-warning { background: #ff9800; border-color: #ff9800; }
        .btn-warning:hover { background: #e68a00; }
        .btn-logout { background: #f44336; border-color: #f44336; float: right; text-decoration: none; color: white; padding: 10px 15px; border-radius: 5px; font-weight: bold; }
        .btn-logout:hover { background: #da190b; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th, td { border: 1px solid #444; padding: 12px; text-align: left; }
        th { background-color: #333; color: #4CAF50; }
        tr:nth-child(even) { background-color: #252525; }
        .action-form { display: inline-block; margin: 2px; }
        .response-box { background: #222; border: 1px solid #444; padding: 15px; margin: 20px 0; border-radius: 5px; white-space: pre-wrap; word-wrap: break-word; font-family: monospace; }
        .grid { display: grid; grid-template-columns: 1fr 1fr; gap: 20px; }
        .card { background: #2a2a2a; padding: 20px; border-radius: 5px; }
        @media (max-width: 768px) { .grid { grid-template-columns: 1fr; } }
        
        /* Anti-DevTools Overlay */
        #devtools-blocker {
            position: fixed; top: 0; left: 0; width: 100%; height: 100%;
            background: rgba(0,0,0,0.95); color: #f44336;
            display: none; align-items: center; justify-content: center;
            z-index: 9999; text-align: center; font-size: 24px;
        }
    </style>
</head>
<body>
    <div id="devtools-blocker">
        <h1>🚫 Developer tools are not allowed. 🚫</h1>
        <p>Please close the developer console to use this page.</p>
    </div>

    <script>
        (function() {
            const blocker = document.getElementById('devtools-blocker');
            
            function detectDevTools() {
                const threshold = 160; // Dimension threshold
                
                // Check 1: Window dimension change
                const widthDiff = window.outerWidth - window.innerWidth;
                const heightDiff = window.outerHeight - window.innerHeight;

                if (widthDiff > threshold || heightDiff > threshold) {
                    blocker.style.display = 'flex';
                }

                // Check 2: Debugger statement
                // This will pause execution ONLY if devtools are open
                const startTime = new Date();
                debugger;
                const endTime = new Date();

                if (endTime - startTime > 100) { // If it took > 100ms
                    blocker.style.display = 'flex';
                }
            }
            
            // Check repeatedly
            setInterval(detectDevTools, 1000);
            
            // Also block context menu (right-click)
            document.addEventListener('contextmenu', function(e) {
                e.preventDefault();
            });
            // Block F12 and other shortcuts
            document.addEventListener('keydown', function(e) {
                if (
                    e.key === 'F12' || 
                    (e.ctrlKey && e.shiftKey && (e.key === 'I' || e.key === 'J' || e.key === 'C')) ||
                    (e.ctrlKey && e.key === 'U')
                ) {
                    e.preventDefault();
                    blocker.style.display = 'flex';
                }
            });
        })();
    </script>
    <div class="container">
        <a href="?logout=true" class="btn-logout">Logout</a>
        <h1>👑 Admin Panel By SohaM GamePlay 👑</h1>

        <form method="POST" class="card">
            <label for="game"><strong>📌 Select a Game:</strong></label>
            <select name="game" id="game">
                <option value="sf2" <?php echo ($_SESSION['game'] ?? '') == 'sf2' ? 'selected' : ''; ?>>Shadow Fight 2</option>
                <option value="sf3" <?php echo ($_SESSION['game'] ?? '') == 'sf3' ? 'selected' : ''; ?>>Shadow Fight 3</option>
                <option value="sfa" <?php echo ($_SESSION['game'] ?? '') == 'sfa' ? 'selected' : ''; ?>>Shadow Fight Arena</option>
            </select>
            <button type="submit" name="select_game">Load Game Config</button>
            <?php if ($current_game_config): ?>
                <h3 style="color: #4CAF50; display: inline; margin-left: 20px;">
                    ✅ Loaded: <?php echo htmlspecialchars($current_game_config['name']); ?>
                </h3>
            <?php endif; ?>
        </form>

        <?php if ($action_response): ?>
            <h2>Server Response:</h2>
            <div class="response-box"><?php echo nl2br(htmlspecialchars($action_response)); ?></div>
        <?php endif; ?>
        
        <?php if ($current_game_config): ?>
            <div class="grid">
                <div class="card">
                    <h2>🛒 Register New User</h2>
                    <form method="POST">
                        <input type="hidden" name="action" value="register">
                        <label for="username">Username:</label><br>
                        <input type="text" id="username" name="username" required style="width: 100%;"><br>
                        <label for="password">Password:</label><br>
                        <input type="text" id="password" name="password" value="smgp" required style="width: 100%;"><br>
                        <label for="days">Days:</label><br>
                        <input type="number" id="days" name="days" required style="width: 100%;"><br><br>
                        <button type="submit">Register User</button>
                    </form>
                </div>

                <div class="card">
                    <h2>❕ Logs</h2>
                    <form method="POST" class="action-form">
                        <input type="hidden" name="action" value="view_log">
                        <button type="submit">🧾 Show Log</button>
                    </form>
                    <form method="POST" class="action-form">
                        <input type="hidden" name="action" value="delete_log">
                        <button type="submit" class="btn-danger">❎ Delete Log</button>
                    </form>
                </div>
            </div>

            <h2>👤 Users List</h2>
            <table>
                <thead>
                    <tr>
                        <th>Username</th>
                        <th>Password</th>
                        <th>Expire</th>
                        <th>Active</th>
                        <th>Last Login</th>
                        <th>Admin</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($users_list as $user): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($user['Name']); ?></td>
                            <td><?php echo htmlspecialchars($user['Password']); ?></td>
                            <td><?php echo htmlspecialchars($user['Expire']); ?></td>
                            <td><?php echo htmlspecialchars($user['Active']); ?></td>
                            <td><?php echo htmlspecialchars($user['LastLogin']); ?></td>
                            <td><?php echo htmlspecialchars($user['Admin']); ?></td>
                            <td>
                                <form method="POST" class="action-form">
                                    <input type="hidden" name="action" value="renew">
                                    <input type="hidden" name="username" value="<?php echo htmlspecialchars($user['Name']); ?>">
                                    <input type="number" name="days" placeholder="Days" style="width: 70px;" required>
                                    <button type="submit">🔄 Renew</button>
                                </form>
                                <form method="POST" class="action-form">
                                    <input type="hidden" name="action" value="reset">
                                    <input type="hidden" name="username" value="<?php echo htmlspecialchars($user['Name']); ?>">
                                    <button type="submit" class="btn-warning">🔁 Reset</button>
                                </form>
                                <form method="POST" class="action-form">
                                    <input type="hidden" name="action" value="delete">
                                    <input type="hidden" name="username" value="<?php echo htmlspecialchars($user['Name']); ?>">
                                    <button type="submit" class="btn-danger">🚫 Delete</button>
                                </form>
                                <form method="POST" class="action-form" style="border-top: 1px solid #555; padding-top: 5px; margin-top: 5px; width: 100%;">
                                    <input type="hidden" name="action" value="edit">
                                    <input type="hidden" name="username" value="<?php echo htmlspecialchars($user['Name']); ?>">
                                    <input type="text" name="password" value="<?php echo htmlspecialchars($user['Password']); ?>" style="width: 100px;">
                                    <input type="text" name="expire_date" value="<?php echo htmlspecialchars($user['Expire']); ?>" style="width: 100px;">
                                    <label><input type="checkbox" name="active" <?php echo $user['Active'] == 'true' ? 'checked' : ''; ?>> Active</label>
                                    <label><input type="checkbox" name="admin" <?php echo $user['Admin'] == 'true' ? 'checked' : ''; ?>> Admin</label>
                                    <button type="submit" class="btn-warning">📝 Edit</button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php else: ?>
            <p>Please select a game to load the admin panel.</p>
        <?php endif; ?>
    </div>
</body>
</html>
