<?php
// validate.php?key=SOHAM-XXXX&device=OnePlus8
$file = 'keys.json';

$userKey = isset($_GET['key']) ? $_GET['key'] : '';
$userDevice = isset($_GET['device']) ? $_GET['device'] : '';

if (!$userKey || !$userDevice) {
    die("Error: Missing Data");
}

if (!file_exists($file)) {
    die("Error: No database");
}

$data = json_decode(file_get_contents($file), true);

if (isset($data[$userKey])) {
    $keyData = $data[$userKey];
    $timeCreated = $keyData['time'];
    $lockedDevice = $keyData['device'];
    
    // 1. Check Time (24 Hours = 86400 seconds)
    if (time() - $timeCreated > 86400) {
        die("Expired");
    }
    
    // 2. Check Device Lock
    if ($lockedDevice == null) {
        // First time use! Lock it to this device
        $data[$userKey]['device'] = $userDevice;
        file_put_contents($file, json_encode($data));
        echo "Success"; // LOGIN OK
    } elseif ($lockedDevice == $userDevice) {
        // Same device returning
        echo "Success"; // LOGIN OK
    } else {
        // Different device trying to use same key
        die("DeviceMismatch");
    }
    
} else {
    die("Invalid");
}
?>
