<?php
// start.php - The Entry Point
// 1. Enter your Link Shortener URL here
// finish.php
$shortener_link = "https://arolinks.com/Rc2A"; 

$file = 'ip_log.json';
$ip = $_SERVER['REMOTE_ADDR'];
$now = time();

// Load existing IPs
$data = [];
if (file_exists($file)) {
    $data = json_decode(file_get_contents($file), true);
}

// Clean up old IPs (older than 10 minutes) to keep file fast
foreach ($data as $k => $v) {
    if ($now - $v > 600) {
        unset($data[$k]);
    }
}

// Add User's IP with current time
$data[$ip] = $now;

// Save
file_put_contents($file, json_encode($data));

// Redirect user to the Link Shortener
header("Location: " . $shortener_link);
exit();
?>
