<?php
// finish.php - The Destination (Put this link INSIDE your Link Shortener settings)
$file_keys = 'keys.json';
$file_ips = 'ip_log.json';
$ip = $_SERVER['REMOTE_ADDR'];

// --- SECURITY CHECK START ---
$valid_session = false;

if (file_exists($file_ips)) {
    $ips = json_decode(file_get_contents($file_ips), true);
    
    // Check if IP exists in the log
    if (isset($ips[$ip])) {
        $time_started = $ips[$ip];
        
        // OPTIONAL: Check if they completed it "too fast" (e.g. under 10 seconds)
        // If they arrived in 1 second, they might be using a bot to skip ads.
        if (time() - $time_started > 5) {
            $valid_session = true;
            
            // REMOVE IP so they can't refresh page to get infinite keys
            unset($ips[$ip]);
            file_put_contents($file_ips, json_encode($ips));
        } else {
            die("<html><body style='background:black;color:red;'><h1>Too Fast!</h1><p>Please watch the ads properly.</p></body></html>");
        }
    }
}

if (!$valid_session) {
    // If they came here directly without going to start.php
    die("<html><body style='background:black;color:red;text-align:center;padding-top:50px;'>
         <h1>Access Denied</h1>
         <p>Direct access is not allowed.</p>
         <p>Please click 'Get Key' inside the App.</p>
         </body></html>");
}
// --- SECURITY CHECK END ---

// --- GENERATION LOGIC (Same as before) ---
$random = substr(str_shuffle("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, 6);
$key = "SOHAM-" . $random;
$now = time();

$data = [];
if (file_exists($file_keys)) {
    $data = json_decode(file_get_contents($file_keys), true);
}

// Cleanup old keys
foreach ($data as $k => $v) {
    if ($now - $v['time'] > 30 * 3600) unset($data[$k]);
}

// Save New Key
$data[$key] = ["time" => $now, "device" => null];
file_put_contents($file_keys, json_encode($data));

// Display Key
echo "<html><body style='background:black; color:white; text-align:center; font-family:sans-serif; padding-top:50px;'>";
echo "<h1>Key Generated!</h1>";
echo "<h2 style='color:#0f0; border:2px dashed #0f0; display:inline-block; padding:10px;'>$key</h2>";
echo "<p>Valid for 24 Hours.</p>";
echo "</body></html>";
?>
